/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.internal.corext.callhierarchy;

import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.dltk.ast.references.SimpleReference;
import org.eclipse.dltk.core.DLTKCore;
import org.eclipse.dltk.core.DLTKLanguageManager;
import org.eclipse.dltk.core.ICalleeProcessor;
import org.eclipse.dltk.core.IDLTKLanguageToolkit;
import org.eclipse.dltk.core.IMethod;
import org.eclipse.dltk.core.IModelElement;
import org.eclipse.dltk.core.search.IDLTKSearchScope;
import org.eclipse.dltk.internal.corext.callhierarchy.CallHierarchy;
import org.eclipse.dltk.internal.corext.callhierarchy.CallHierarchyMessages;
import org.eclipse.dltk.internal.corext.callhierarchy.CallLocation;
import org.eclipse.dltk.internal.corext.callhierarchy.CallSearchResultCollector;
import org.eclipse.dltk.internal.corext.callhierarchy.MethodCall;
import org.eclipse.dltk.internal.corext.callhierarchy.MethodWrapper;

class CalleeMethodWrapper
extends MethodWrapper {
    private Comparator fMethodWrapperComparator = new MethodWrapperComparator();

    public CalleeMethodWrapper(MethodWrapper parent, MethodCall methodCall) {
        super(parent, methodCall);
    }

    @Override
    public MethodWrapper[] getCalls(IProgressMonitor progressMonitor) {
        MethodWrapper[] result = super.getCalls(progressMonitor);
        Arrays.sort(result, this.fMethodWrapperComparator);
        return result;
    }

    @Override
    protected String getTaskName() {
        return CallHierarchyMessages.CalleeMethodWrapper_taskname;
    }

    @Override
    protected MethodWrapper createMethodWrapper(MethodCall methodCall) {
        return new CalleeMethodWrapper(this, methodCall);
    }

    @Override
    protected Map findChildren(IProgressMonitor progressMonitor) {
        IDLTKLanguageToolkit toolkit;
        if (this.getMember().exists() && this.getMember().getElementType() == 9 && (toolkit = DLTKLanguageManager.getLanguageToolkit((IModelElement)this.getMember())) != null) {
            Map result;
            IDLTKSearchScope scope = CallHierarchy.getDefault().getSearchScope(toolkit);
            ICalleeProcessor processor = DLTKLanguageManager.createCalleeProcessor((String)toolkit.getNatureId(), (IMethod)((IMethod)this.getMember()), (IProgressMonitor)progressMonitor, (IDLTKSearchScope)scope);
            if (processor != null && (result = processor.doOperation()) != null) {
                CallSearchResultCollector collector = new CallSearchResultCollector();
                Set keys = result.keySet();
                for (SimpleReference e : keys) {
                    IMethod[] calls = (IMethod[])result.get(e);
                    int j = 0;
                    while (j < calls.length) {
                        collector.addMember(this.getMember(), (IModelElement)calls[j], e.sourceStart(), e.sourceEnd());
                        ++j;
                    }
                }
                return collector.getCallers();
            }
        }
        if (DLTKCore.DEBUG) {
            System.err.println("TODO:CalleeMethodWrap findChildren not implemented...");
        }
        return new HashMap(0);
    }

    private static class MethodWrapperComparator
    implements Comparator {
        private MethodWrapperComparator() {
        }

        public int compare(Object o1, Object o2) {
            MethodWrapper m1 = (MethodWrapper)((Object)o1);
            MethodWrapper m2 = (MethodWrapper)((Object)o2);
            CallLocation callLocation1 = m1.getMethodCall().getFirstCallLocation();
            CallLocation callLocation2 = m2.getMethodCall().getFirstCallLocation();
            if (callLocation1 != null && callLocation2 != null) {
                if (callLocation1.getStart() == callLocation2.getStart()) {
                    return callLocation1.getEnd() - callLocation2.getEnd();
                }
                return callLocation1.getStart() - callLocation2.getStart();
            }
            return 0;
        }
    }
}

