/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.internal.ui.refactoring.reorg;

import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.dltk.core.IModelElement;
import org.eclipse.dltk.core.IProjectFragment;
import org.eclipse.dltk.core.IScriptFolder;
import org.eclipse.dltk.core.ISourceModule;
import org.eclipse.dltk.core.ModelException;
import org.eclipse.dltk.core.ScriptModelUtil;
import org.eclipse.dltk.internal.corext.refactoring.reorg.ReorgUtils;
import org.eclipse.dltk.internal.corext.refactoring.reorg.ScriptDeleteProcessor;
import org.eclipse.dltk.internal.corext.refactoring.util.ModelElementUtil;
import org.eclipse.dltk.internal.corext.util.Messages;
import org.eclipse.dltk.internal.ui.refactoring.MessageWizardPage;
import org.eclipse.dltk.internal.ui.refactoring.RefactoringMessages;
import org.eclipse.dltk.internal.ui.refactoring.reorg.ReorgQueries;
import org.eclipse.dltk.ui.DLTKUIPlugin;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.ltk.core.refactoring.Refactoring;
import org.eclipse.ltk.core.refactoring.participants.DeleteRefactoring;
import org.eclipse.ltk.core.refactoring.participants.RefactoringProcessor;
import org.eclipse.ltk.ui.refactoring.RefactoringWizard;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;

public class DeleteWizard
extends RefactoringWizard {
    public DeleteWizard(Refactoring refactoring) {
        super(refactoring, 92);
        this.setDefaultPageTitle(RefactoringMessages.DeleteWizard_1);
        ((ScriptDeleteProcessor)((DeleteRefactoring)this.getRefactoring()).getProcessor()).setQueries(new ReorgQueries((Wizard)this));
    }

    protected void addUserInputPages() {
        this.addPage((IWizardPage)new DeleteInputPage());
    }

    public int getMessageLineWidthInChars() {
        return 0;
    }

    public boolean needsProgressMonitor() {
        DeleteRefactoring refactoring = (DeleteRefactoring)this.getRefactoring();
        RefactoringProcessor processor = refactoring.getProcessor();
        if (processor instanceof ScriptDeleteProcessor) {
            return ((ScriptDeleteProcessor)processor).needsProgressMonitor();
        }
        return super.needsProgressMonitor();
    }

    private static class DeleteInputPage
    extends MessageWizardPage {
        private static final String PAGE_NAME = "DeleteInputPage";
        private static final String DIALOG_SETTINGS_DELETE_SUB_PACKAGES = "deleteSubPackages";
        private Button fDeleteSubPackagesCheckBox;

        public DeleteInputPage() {
            super(PAGE_NAME, true, 2);
        }

        @Override
        protected String getMessageString() {
            try {
                if (1 == this.numberOfSelectedElements()) {
                    String pattern = this.createConfirmationStringForOneElement();
                    String name = this.getNameOfSingleSelectedElement();
                    return Messages.format(pattern, new String[]{name});
                }
                String pattern = this.createConfirmationStringForManyElements();
                return Messages.format(pattern, new String[]{String.valueOf(this.numberOfSelectedElements())});
            }
            catch (ModelException e) {
                if (ScriptModelUtil.isExceptionToBeLogged((CoreException)((Object)e))) {
                    DLTKUIPlugin.log(e);
                }
                this.setPageComplete(false);
                if (e.isDoesNotExist()) {
                    return RefactoringMessages.DeleteWizard_12;
                }
                return RefactoringMessages.DeleteWizard_2;
            }
        }

        @Override
        public void createControl(Composite parent) {
            super.createControl(parent);
            if (this.getDeleteProcessor().hasSubPackagesToDelete()) {
                this.addDeleteSubPackagesCheckBox();
            }
        }

        private void addDeleteSubPackagesCheckBox() {
            Composite c = new Composite((Composite)this.getControl(), 0);
            GridLayout gd = new GridLayout();
            gd.horizontalSpacing = 10;
            c.setLayout((Layout)gd);
            GridData data = new GridData(768);
            data.horizontalSpan = 2;
            c.setLayoutData((Object)data);
            boolean selection = this.getRefactoringSettings().getBoolean(DIALOG_SETTINGS_DELETE_SUB_PACKAGES);
            this.fDeleteSubPackagesCheckBox = new Button(c, 32);
            this.fDeleteSubPackagesCheckBox.setText(RefactoringMessages.DeleteWizard_also_delete_sub_packages);
            this.fDeleteSubPackagesCheckBox.setSelection(selection);
            this.fDeleteSubPackagesCheckBox.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent event) {
                    DeleteInputPage.this.getDeleteProcessor().setDeleteSubPackages(DeleteInputPage.this.fDeleteSubPackagesCheckBox.getSelection());
                }
            });
            this.getDeleteProcessor().setDeleteSubPackages(this.fDeleteSubPackagesCheckBox.getSelection());
        }

        private String getNameOfSingleSelectedElement() throws ModelException {
            if (this.getSingleSelectedResource() != null) {
                return ReorgUtils.getName(this.getSingleSelectedResource());
            }
            return ReorgUtils.getName(this.getSingleSelectedScriptElement());
        }

        private IModelElement getSingleSelectedScriptElement() {
            IModelElement[] elements = this.getSelectedScriptElements();
            return elements.length == 1 ? elements[0] : null;
        }

        private IResource getSingleSelectedResource() {
            IResource[] resources = this.getSelectedResources();
            return resources.length == 1 ? resources[0] : null;
        }

        private int numberOfSelectedElements() {
            return this.getSelectedScriptElements().length + this.getSelectedResources().length;
        }

        protected boolean performFinish() {
            return super.performFinish() || this.getDeleteProcessor().wasCanceled();
        }

        protected boolean saveSettings() {
            if (this.getContainer() instanceof Dialog) {
                return ((Dialog)this.getContainer()).getReturnCode() == 0;
            }
            return true;
        }

        public void dispose() {
            if (this.fDeleteSubPackagesCheckBox != null && this.saveSettings()) {
                this.getRefactoringSettings().put(DIALOG_SETTINGS_DELETE_SUB_PACKAGES, this.fDeleteSubPackagesCheckBox.getSelection());
            }
            super.dispose();
        }

        private String createConfirmationStringForOneElement() throws ModelException {
            IModelElement[] elements = this.getSelectedScriptElements();
            if (elements.length == 1) {
                IModelElement element = elements[0];
                if (DeleteInputPage.isDefaultPackageWithLinkedFiles(element)) {
                    return RefactoringMessages.DeleteWizard_3;
                }
                if (!DeleteInputPage.isLinkedResource(element)) {
                    return RefactoringMessages.DeleteWizard_4;
                }
                if (DeleteInputPage.isLinkedPackageOrProjectFragment(element)) {
                    return RefactoringMessages.DeleteWizard_6;
                }
                return RefactoringMessages.DeleteWizard_5;
            }
            if (DeleteInputPage.isLinked(this.getSelectedResources()[0])) {
                return RefactoringMessages.DeleteWizard_7;
            }
            return RefactoringMessages.DeleteWizard_8;
        }

        private String createConfirmationStringForManyElements() throws ModelException {
            IModelElement[] modelElements;
            IResource[] resources = this.getSelectedResources();
            if (!DeleteInputPage.containsLinkedResources(resources, modelElements = this.getSelectedScriptElements())) {
                return RefactoringMessages.DeleteWizard_9;
            }
            if (!DeleteInputPage.containsLinkedPackagesOrProjectFragments(modelElements)) {
                return RefactoringMessages.DeleteWizard_10;
            }
            return RefactoringMessages.DeleteWizard_11;
        }

        private static boolean isLinkedPackageOrProjectFragment(IModelElement element) {
            if (element instanceof IScriptFolder || element instanceof IProjectFragment) {
                return DeleteInputPage.isLinkedResource(element);
            }
            return false;
        }

        private static boolean containsLinkedPackagesOrProjectFragments(IModelElement[] modelElements) {
            int i = 0;
            while (i < modelElements.length) {
                IModelElement element = modelElements[i];
                if (DeleteInputPage.isLinkedPackageOrProjectFragment(element)) {
                    return true;
                }
                ++i;
            }
            return false;
        }

        private static boolean containsLinkedResources(IResource[] resources, IModelElement[] modelElements) throws ModelException {
            int i = 0;
            while (i < modelElements.length) {
                IModelElement element = modelElements[i];
                if (DeleteInputPage.isLinkedResource(element)) {
                    return true;
                }
                if (DeleteInputPage.isDefaultPackageWithLinkedFiles(element)) {
                    return true;
                }
                ++i;
            }
            i = 0;
            while (i < resources.length) {
                IResource resource = resources[i];
                if (DeleteInputPage.isLinked(resource)) {
                    return true;
                }
                ++i;
            }
            return false;
        }

        private static boolean isDefaultPackageWithLinkedFiles(Object firstElement) throws ModelException {
            if (!ModelElementUtil.isDefaultPackage(firstElement)) {
                return false;
            }
            IScriptFolder defaultPackage = (IScriptFolder)firstElement;
            ISourceModule[] cus = defaultPackage.getSourceModules();
            int i = 0;
            while (i < cus.length) {
                if (DeleteInputPage.isLinkedResource((IModelElement)cus[i])) {
                    return true;
                }
                ++i;
            }
            return false;
        }

        private static boolean isLinkedResource(IModelElement element) {
            return DeleteInputPage.isLinked(ReorgUtils.getResource(element));
        }

        private static boolean isLinked(IResource resource) {
            return resource != null && resource.isLinked();
        }

        private IModelElement[] getSelectedScriptElements() {
            return this.getDeleteProcessor().getScriptElementsToDelete();
        }

        private IResource[] getSelectedResources() {
            return this.getDeleteProcessor().getResourcesToDelete();
        }

        private ScriptDeleteProcessor getDeleteProcessor() {
            return (ScriptDeleteProcessor)((DeleteRefactoring)this.getRefactoring()).getProcessor();
        }
    }
}

