/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.javascript.parser;

import java.io.IOException;
import java.io.InputStream;
import java.util.Stack;
import org.antlr.runtime.ANTLRInputStream;
import org.antlr.runtime.ANTLRStringStream;
import org.antlr.runtime.BitSet;
import org.antlr.runtime.CharStream;
import org.antlr.runtime.IntStream;
import org.antlr.runtime.MismatchedSetException;
import org.antlr.runtime.MismatchedTokenException;
import org.antlr.runtime.NoViableAltException;
import org.antlr.runtime.Parser;
import org.antlr.runtime.RecognitionException;
import org.antlr.runtime.Token;
import org.antlr.runtime.TokenStream;
import org.eclipse.core.runtime.Assert;
import org.eclipse.dltk.ast.parser.ISourceParser;
import org.eclipse.dltk.compiler.env.IModuleSource;
import org.eclipse.dltk.compiler.problem.IProblem;
import org.eclipse.dltk.compiler.problem.IProblemReporter;
import org.eclipse.dltk.compiler.problem.ProblemSeverity;
import org.eclipse.dltk.core.DLTKCore;
import org.eclipse.dltk.core.IModelElement;
import org.eclipse.dltk.core.ISourceModule;
import org.eclipse.dltk.core.ISourceRange;
import org.eclipse.dltk.core.SourceRange;
import org.eclipse.dltk.core.builder.ISourceLineTracker;
import org.eclipse.dltk.javascript.ast.Expression;
import org.eclipse.dltk.javascript.ast.Script;
import org.eclipse.dltk.javascript.internal.parser.JSCommonTokenStream;
import org.eclipse.dltk.javascript.internal.parser.NodeTransformerManager;
import org.eclipse.dltk.javascript.parser.DynamicTokenStream;
import org.eclipse.dltk.javascript.parser.JSParser;
import org.eclipse.dltk.javascript.parser.JSParserMessages;
import org.eclipse.dltk.javascript.parser.JSParserRule;
import org.eclipse.dltk.javascript.parser.JSParserState;
import org.eclipse.dltk.javascript.parser.JSProblem;
import org.eclipse.dltk.javascript.parser.JSTokenStream;
import org.eclipse.dltk.javascript.parser.JSTransformer;
import org.eclipse.dltk.javascript.parser.JavaScriptLexer;
import org.eclipse.dltk.javascript.parser.JavaScriptParserPlugin;
import org.eclipse.dltk.javascript.parser.JavaScriptParserProblems;
import org.eclipse.dltk.javascript.parser.JavaScriptParserUtil;
import org.eclipse.dltk.javascript.parser.JavaScriptTokenSource;
import org.eclipse.dltk.javascript.parser.NodeTransformer;
import org.eclipse.dltk.javascript.parser.Reporter;
import org.eclipse.dltk.utils.TextUtils;

public class JavaScriptParser
implements ISourceParser {
    private boolean xmlEnabled = true;
    public static final String PARSER_ID = "org.eclipse.dltk.javascript.NewParser";

    public boolean isXmlEnabled() {
        return this.xmlEnabled;
    }

    public void setXmlEnabled(boolean xmlEnabled) {
        this.xmlEnabled = xmlEnabled;
    }

    public Script parse(IModuleSource input, IProblemReporter reporter) {
        Assert.isNotNull((Object)input);
        char[] source = input.getContentsAsCharArray();
        return this.parse(input.getModelElement(), this.createTokenStream(source), reporter == null ? null : new Reporter(TextUtils.createLineTracker((char[])source), reporter));
    }

    public Script parse(String source, IProblemReporter reporter) {
        Assert.isNotNull((Object)source);
        return this.parse(null, this.createTokenStream(source), TextUtils.createLineTracker((String)source), reporter);
    }

    public Expression expression(String source, IProblemReporter _reporter) {
        try {
            Reporter reporter = new Reporter(TextUtils.createLineTracker((String)source), _reporter);
            JSTokenStream stream = this.createTokenStream(source);
            stream.setReporter(reporter);
            JSParser parser = this.createTreeParser(stream, reporter);
            JSParser.standaloneExpression_return root = parser.standaloneExpression();
            JSTransformer transformer = new JSTransformer(stream.getTokens(), parser.peekState().hasErrors());
            transformer.setReporter(reporter);
            return (Expression)transformer.transform(root);
        }
        catch (Exception e) {
            if (DLTKCore.DEBUG) {
                e.printStackTrace();
            }
            if (_reporter != null) {
                _reporter.reportProblem((IProblem)new JSProblem(e));
            }
            return null;
        }
    }

    public JSParser createTreeParser(JSTokenStream stream, Reporter reporter) {
        JSParser parser = new JSParser(stream);
        parser.reporter = reporter;
        parser.xmlEnabled = this.xmlEnabled;
        return parser;
    }

    protected Script parse(IModelElement element, JSTokenStream stream, ISourceLineTracker lineTracker, IProblemReporter reporter) {
        return this.parse(element, stream, new Reporter(lineTracker, reporter));
    }

    protected Script parse(IModelElement element, JSTokenStream stream, Reporter reporter) {
        try {
            stream.setReporter(reporter);
            JSParser parser = this.createTreeParser(stream, reporter);
            JSParser.program_return root = parser.program();
            NodeTransformer[] transformers = NodeTransformerManager.createTransformers(element, reporter);
            JSTransformer transformer = new JSTransformer(transformers, stream.getTokens(), parser.peekState().hasErrors());
            transformer.setReporter(reporter);
            Script script = transformer.transformScript(root);
            if (element != null && element instanceof ISourceModule) {
                script.setAttribute(JavaScriptParserUtil.ATTR_MODULE, element);
            }
            return script;
        }
        catch (Exception e) {
            JavaScriptParserPlugin.error(e);
            if (reporter != null) {
                reporter.reportProblem((IProblem)new JSProblem(e));
            }
            return new Script();
        }
    }

    public JSTokenStream createTokenStream(char[] source) {
        ANTLRStringStream charStream = new ANTLRStringStream(source, source.length);
        return this.createTokenStream((CharStream)charStream);
    }

    public JSTokenStream createTokenStream(String source) {
        ANTLRStringStream charStream = new ANTLRStringStream(source);
        return this.createTokenStream((CharStream)charStream);
    }

    public JSTokenStream createTokenStream(InputStream input, String encoding) throws IOException {
        ANTLRInputStream charStream = new ANTLRInputStream(input, encoding);
        return this.createTokenStream((CharStream)charStream);
    }

    private JSTokenStream createTokenStream(CharStream charStream) {
        if (this.xmlEnabled) {
            return new DynamicTokenStream(new JavaScriptTokenSource(charStream));
        }
        return new JSCommonTokenStream(new JavaScriptLexer(charStream));
    }

    static class JSBaseParser
    extends Parser {
        Reporter reporter;
        boolean xmlEnabled;
        private JSParserMessages messages = null;
        private final Stack<JSParserState> states = new Stack();

        public JSBaseParser(TokenStream input) {
            super(input);
        }

        protected boolean isXmlEnabled() {
            return this.xmlEnabled;
        }

        protected void reportFailure(Throwable t) {
            if (this.reporter != null && !this.peekState().hasErrors()) {
                this.reporter.reportProblem((IProblem)new JSProblem(t));
            }
        }

        private JSParserMessages getMessages() {
            if (this.messages == null) {
                this.messages = new JSParserMessages();
            }
            return this.messages;
        }

        private String getTokenName(int token) {
            String message = this.getMessages().get(token);
            if (message == null) {
                message = this.getTokenNames()[token];
            }
            return message;
        }

        public String getTokenErrorDisplay(Token t) {
            String message = this.getMessages().get(t.getType());
            if (message != null) {
                return message;
            }
            return super.getTokenErrorDisplay(t);
        }

        public void displayRecognitionError(String[] tokenNames, RecognitionException re) {
            String message;
            ISourceRange range;
            this.peekState().incrementErrorCount();
            if (this.reporter == null) {
                return;
            }
            if (re instanceof NoViableAltException) {
                range = this.convert(re.token);
                Token token = this.getLastToken(re.token);
                message = this.getMessages().get(this.peekState().rule, token.getType());
                if (message == null) {
                    message = "Unexpected " + this.getTokenErrorDisplay(re.token);
                }
            } else if (re instanceof MismatchedTokenException) {
                MismatchedTokenException mte = (MismatchedTokenException)((Object)re);
                if (re.token == Token.EOF_TOKEN) {
                    message = String.valueOf(this.getTokenName(mte.expecting)) + " expected";
                } else {
                    message = "Mismatched input " + this.getTokenErrorDisplay(re.token);
                    if (mte.expecting >= 0 && mte.expecting < tokenNames.length) {
                        message = String.valueOf(message) + ", " + this.getTokenName(mte.expecting) + " expected";
                    }
                }
                range = this.convert(re.token);
                if (range.getLength() + range.getOffset() >= this.inputLength()) {
                    int stop = this.inputLength() - 1;
                    int start = Math.min(stop - 1, range.getOffset() - 2);
                    range = new SourceRange(start, stop - start);
                }
            } else if (re instanceof MismatchedSetException) {
                MismatchedSetException mse = (MismatchedSetException)re;
                message = "Mismatched input " + this.getTokenErrorDisplay(re.token);
                if (mse.expecting != null) {
                    message = String.valueOf(message) + " expecting set " + mse.expecting;
                }
                range = this.convert(re.token);
            } else {
                message = "Syntax Error:" + re.getMessage();
                range = this.convert(re.token);
            }
            this.reporter.setMessage(JavaScriptParserProblems.SYNTAX_ERROR, message);
            this.reporter.setSeverity(ProblemSeverity.ERROR);
            if (range != null) {
                this.reporter.setRange(range.getOffset(), range.getOffset() + range.getLength());
            }
            this.reporter.setLine(re.line - 1);
            this.reporter.report();
        }

        private Token getLastToken(Token token) {
            if (token == Token.EOF_TOKEN) {
                TokenStream stream = this.getTokenStream();
                int index = stream.index();
                while (index > 0) {
                    Token prevToken;
                    if ((prevToken = stream.get(--index)).getType() == 163 || prevToken.getType() == 170) continue;
                    token = prevToken;
                    break;
                }
            }
            return token;
        }

        private ISourceRange convert(Token token) {
            if ((token = this.getLastToken(token)) == Token.EOF_TOKEN) {
                return null;
            }
            return this.reporter.toSourceRange(token);
        }

        private int inputLength() {
            return this.reporter.getLength();
        }

        public void recoverFromMismatchedToken(IntStream input, RecognitionException e, int ttype, BitSet follow) throws RecognitionException {
            if (input.LA(2) == ttype) {
                this.reportError(e);
                this.beginResync();
                input.consume();
                this.endResync();
                input.consume();
                return;
            }
            if (ttype == 70) {
                this.displayRecognitionError(this.getTokenNames(), e);
                return;
            }
            if (!this.recoverFromMismatchedElement(input, e, follow)) {
                throw e;
            }
        }

        protected void syncToSet() {
            BitSet follow = this.following[this._fsp];
            int mark = this.input.mark();
            try {
                Token first = null;
                Token last = null;
                while (!follow.member(this.input.LA(1))) {
                    if (this.input.LA(1) == -1) {
                        this.input.rewind();
                        mark = -1;
                        return;
                    }
                    last = this.input.LT(1);
                    if (first == null) {
                        first = last;
                    }
                    this.input.consume();
                }
                if (first != null && this.reporter != null) {
                    ISourceRange end = this.convert(last);
                    this.reporter.setMessage(JavaScriptParserProblems.SYNTAX_ERROR, "Unexpected input was discarded");
                    this.reporter.setSeverity(ProblemSeverity.ERROR);
                    this.reporter.setRange(this.convert(first).getOffset(), end.getOffset() + end.getLength());
                    this.reporter.setLine(first.getLine() - 1);
                    this.reporter.report();
                }
            }
            finally {
                if (mark != -1) {
                    this.input.release(mark);
                }
            }
        }

        protected void reportReservedKeyword(Token token) {
            if (this.reporter == null) {
                return;
            }
            ISourceRange range = this.convert(token);
            this.reporter.setFormattedMessage(JavaScriptParserProblems.RESERVED_KEYWORD, token.getText());
            this.reporter.setSeverity(ProblemSeverity.ERROR);
            this.reporter.setRange(range.getOffset(), range.getOffset() + range.getLength());
            this.reporter.setLine(token.getLine() - 1);
            this.reporter.report();
        }

        protected void reportError(String message, Token token) {
            if (this.reporter == null) {
                return;
            }
            ISourceRange range = this.convert(token);
            this.reporter.setMessage(JavaScriptParserProblems.SYNTAX_ERROR, message);
            this.reporter.setSeverity(ProblemSeverity.ERROR);
            this.reporter.setRange(range.getOffset(), range.getOffset() + range.getLength());
            this.reporter.setLine(token.getLine() - 1);
            this.reporter.report();
        }

        protected BitSet combineFollows(boolean exact) {
            int top = this._fsp;
            BitSet followSet = new BitSet();
            int i = top;
            while (i >= 0) {
                BitSet localFollowSet = this.following[i];
                followSet.orInPlace(localFollowSet);
                if (exact && localFollowSet != null && !localFollowSet.member(1)) break;
                --i;
            }
            followSet.remove(1);
            return followSet;
        }

        protected void reportRuleError(RecognitionException re) {
            this.reportError(re);
            this.recover((IntStream)this.input, re);
        }

        protected void pushState(JSParserRule rule) {
            this.states.push(new JSParserState(this.peekState(), rule));
        }

        protected void popState() {
            this.states.pop();
        }

        public JSParserState peekState() {
            return this.states.isEmpty() ? null : this.states.peek();
        }
    }
}

