/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.internal.ui.text.spelling;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.content.IContentType;
import org.eclipse.dltk.compiler.problem.IProblem;
import org.eclipse.dltk.core.IProblemRequestor;
import org.eclipse.dltk.internal.ui.text.spelling.ScriptSpellingProblem;
import org.eclipse.dltk.ui.text.spelling.SpellCheckDelegate;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.text.reconciler.DirtyRegion;
import org.eclipse.jface.text.reconciler.IReconcilingStrategy;
import org.eclipse.jface.text.reconciler.IReconcilingStrategyExtension;
import org.eclipse.jface.text.source.IAnnotationModel;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.editors.text.EditorsUI;
import org.eclipse.ui.texteditor.IDocumentProvider;
import org.eclipse.ui.texteditor.ITextEditor;
import org.eclipse.ui.texteditor.spelling.ISpellingProblemCollector;
import org.eclipse.ui.texteditor.spelling.SpellingContext;
import org.eclipse.ui.texteditor.spelling.SpellingProblem;
import org.eclipse.ui.texteditor.spelling.SpellingService;

public class ScriptSpellingReconcileStrategy
implements IReconcilingStrategy,
IReconcilingStrategyExtension {
    private final SpellingService fSpellingService = EditorsUI.getSpellingService();
    protected final ITextEditor fEditor;
    protected IProblemRequestor fRequestor;
    private final String fPartitioning;
    private final SpellingContext fSpellingContext;
    protected SpellCheckDelegate fCheckDelegate;
    private IDocument fDocument;
    private IProgressMonitor fProgressMonitor;
    private ISpellingProblemCollector fSpellingProblemCollector;

    public ScriptSpellingReconcileStrategy(ITextEditor editor, String partitioning, IContentType contentType, SpellCheckDelegate checkDelegate) {
        this.fEditor = editor;
        this.fPartitioning = partitioning;
        this.fSpellingContext = new SpellingContext();
        this.fSpellingContext.setContentType(contentType);
        this.fCheckDelegate = checkDelegate;
    }

    public void initialReconcile() {
        this.reconcile((IRegion)new Region(0, this.fDocument.getLength()));
    }

    public void reconcile(DirtyRegion dirtyRegion, IRegion subRegion) {
        try {
            IRegion startLineInfo = this.fDocument.getLineInformationOfOffset(subRegion.getOffset());
            IRegion endLineInfo = this.fDocument.getLineInformationOfOffset(subRegion.getOffset() + Math.max(0, subRegion.getLength() - 1));
            subRegion = startLineInfo.getOffset() == endLineInfo.getOffset() ? startLineInfo : new Region(startLineInfo.getOffset(), endLineInfo.getOffset() + Math.max(0, endLineInfo.getLength() - 1) - startLineInfo.getOffset());
        }
        catch (BadLocationException badLocationException) {
            subRegion = new Region(0, this.fDocument.getLength());
        }
        this.reconcile((IRegion)subRegion);
    }

    /*
     * Exception decompiling
     */
    public void reconcile(IRegion region) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [6[WHILELOOP]], but top level block is 2[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private boolean isSpellingEnabled() {
        return EditorsUI.getPreferenceStore().getBoolean("spellingEnabled");
    }

    public void setDocument(IDocument document) {
        this.fDocument = document;
        this.fSpellingProblemCollector = new SpellingProblemCollector();
        this.updateProblemRequester();
    }

    private void updateProblemRequester() {
        IAnnotationModel model = this.getAnnotationModel();
        this.fRequestor = model instanceof IProblemRequestor ? (IProblemRequestor)model : null;
    }

    private IAnnotationModel getAnnotationModel() {
        IDocumentProvider documentProvider = this.fEditor.getDocumentProvider();
        if (documentProvider == null) {
            return null;
        }
        return documentProvider.getAnnotationModel((Object)this.fEditor.getEditorInput());
    }

    protected final IDocument getDocument() {
        return this.fDocument;
    }

    public final void setProgressMonitor(IProgressMonitor monitor) {
        this.fProgressMonitor = monitor;
    }

    private class SpellingProblemCollector
    implements ISpellingProblemCollector {
        SpellingProblemCollector() {
        }

        public void accept(SpellingProblem problem) {
            IProblemRequestor requestor = ScriptSpellingReconcileStrategy.this.fRequestor;
            if (requestor != null) {
                try {
                    IDocument document = ScriptSpellingReconcileStrategy.this.getDocument();
                    int line = document.getLineOfOffset(problem.getOffset()) + 1;
                    String word = document.get(problem.getOffset(), problem.getLength());
                    IEditorInput editorInput = ScriptSpellingReconcileStrategy.this.fEditor.getEditorInput();
                    if (editorInput != null) {
                        ScriptSpellingProblem iProblem = new ScriptSpellingProblem(problem.getOffset(), problem.getOffset() + problem.getLength(), line, problem.getMessage(), word, false, false, document, editorInput.getName(), problem);
                        requestor.acceptProblem((IProblem)iProblem);
                    }
                }
                catch (BadLocationException badLocationException) {}
            }
        }

        public void beginCollecting() {
            if (ScriptSpellingReconcileStrategy.this.fRequestor != null) {
                ScriptSpellingReconcileStrategy.this.fRequestor.beginReporting();
            }
        }

        public void endCollecting() {
            if (ScriptSpellingReconcileStrategy.this.fRequestor != null) {
                ScriptSpellingReconcileStrategy.this.fRequestor.endReporting();
            }
        }
    }
}

