/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.javascript.internal.ui.text.folding;

import java.util.List;
import org.eclipse.dltk.javascript.internal.ui.text.JSPartitioningProvider;
import org.eclipse.dltk.javascript.internal.ui.text.folding.JavaScriptFoldingBlockKind;
import org.eclipse.dltk.ui.text.folding.IFoldingBlockKind;
import org.eclipse.dltk.ui.text.folding.IFoldingContent;
import org.eclipse.dltk.ui.text.folding.PartitioningFoldingBlockProvider;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;

public class JavaScriptCommentFoldingBlockProvider
extends PartitioningFoldingBlockProvider {
    public JavaScriptCommentFoldingBlockProvider() {
        super(JSPartitioningProvider.getInstance());
    }

    public void computeFoldableBlocks(IFoldingContent content) {
        if (this.isFoldingComments()) {
            this.computeBlocksForPartitionType(content, "__javascript_single_line_comment", JavaScriptFoldingBlockKind.COMMENT, this.isCollapseComments());
            this.computeBlocksForPartitionType(content, "__javascript_comment", JavaScriptFoldingBlockKind.COMMENT, this.isCollapseComments());
        }
        if (this.isFoldingDocs()) {
            this.computeBlocksForPartitionType(content, "__javascript_doc", JavaScriptFoldingBlockKind.JSDOC, this.isCollapseDocs());
        }
    }

    protected void reportRegions(Document document, List<IRegion> regions, IFoldingBlockKind kind, boolean collapse) throws BadLocationException {
        IRegion first;
        if ((kind == JavaScriptFoldingBlockKind.COMMENT || kind == JavaScriptFoldingBlockKind.JSDOC) && collapse != this.isCollapseHeaderComment() && !regions.isEmpty() && (first = regions.get(0)).getOffset() == 0 && this.isFileHeader((IDocument)document, first)) {
            this.requestor.acceptBlock(first.getOffset(), first.getOffset() + first.getLength(), kind, null, this.isCollapseHeaderComment());
            super.reportRegions(document, regions.subList(1, regions.size()), kind, collapse);
            return;
        }
        super.reportRegions(document, regions, kind, collapse);
    }

    private boolean isFileHeader(IDocument document, IRegion region) throws BadLocationException {
        int endPos = region.getOffset() + region.getLength();
        String txtAfterComment = document.get(endPos, Math.min(20, document.getLength() - endPos));
        int lineDelimiterCount = 0;
        int i = 0;
        while (i < txtAfterComment.length()) {
            char c = txtAfterComment.charAt(i);
            if (c == 'f') {
                if (txtAfterComment.substring(i).startsWith("function")) {
                    return false;
                }
            } else if (c == 'v') {
                if (txtAfterComment.substring(i).startsWith("var")) {
                    return false;
                }
            } else {
                if (lineDelimiterCount == 1) {
                    return true;
                }
                if (c == '\n') {
                    ++lineDelimiterCount;
                } else if (c == '\r') {
                    ++lineDelimiterCount;
                    if (i + 1 < txtAfterComment.length() && txtAfterComment.charAt(i + 1) == '\n') {
                        ++i;
                    }
                }
            }
            if (lineDelimiterCount == 2) {
                return true;
            }
            ++i;
        }
        return false;
    }
}

