/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.internal.core.index.lucene;

import org.apache.lucene.document.BinaryDocValuesField;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.NumericDocValuesField;
import org.apache.lucene.document.StringField;
import org.apache.lucene.index.IndexableField;
import org.apache.lucene.util.BytesRef;
import org.eclipse.dltk.core.index2.IIndexingRequestor;

public final class DocumentFactory {
    public static Document createForReference(String source, IIndexingRequestor.ReferenceInfo info) {
        Document doc = new Document();
        DocumentFactory.addStringEntry(doc, "path", source, false);
        DocumentFactory.addStringEntry(doc, "qualifier", info.qualifier, false);
        DocumentFactory.addStringLCEntry(doc, "elementNameLC", info.elementName, false);
        DocumentFactory.addLongEntry(doc, "offsetNDV", info.offset);
        DocumentFactory.addLongEntry(doc, "lengthNDV", info.length);
        DocumentFactory.addBinaryEntry(doc, "pathBDV", source);
        DocumentFactory.addBinaryEntry(doc, "elementNameBDV", info.elementName);
        DocumentFactory.addBinaryEntry(doc, "qualifierBDV", info.qualifier);
        DocumentFactory.addBinaryEntry(doc, "metadataBDV", info.metadata);
        return doc;
    }

    public static Document createForDeclaration(String source, IIndexingRequestor.DeclarationInfo info) {
        Document doc = new Document();
        DocumentFactory.addStringEntry(doc, "path", source, false);
        DocumentFactory.addStringEntry(doc, "parent", info.parent, false);
        DocumentFactory.addStringEntry(doc, "qualifier", info.qualifier, false);
        DocumentFactory.addStringLCEntry(doc, "elementNameLC", info.elementName, false);
        DocumentFactory.addCCNameEntry(doc, info.elementName);
        DocumentFactory.addLongEntry(doc, "offsetNDV", info.offset);
        DocumentFactory.addLongEntry(doc, "lengthNDV", info.length);
        DocumentFactory.addLongEntry(doc, "nameOffsetNDV", info.nameOffset);
        DocumentFactory.addLongEntry(doc, "nameLengthNDV", info.nameLength);
        DocumentFactory.addLongEntry(doc, "flagsNDV", info.flags);
        DocumentFactory.addBinaryEntry(doc, "pathBDV", source);
        DocumentFactory.addBinaryEntry(doc, "elementNameBDV", info.elementName);
        DocumentFactory.addBinaryEntry(doc, "parentBDV", info.parent);
        DocumentFactory.addBinaryEntry(doc, "qualifierBDV", info.qualifier);
        DocumentFactory.addBinaryEntry(doc, "metadataBDV", info.metadata);
        DocumentFactory.addBinaryEntry(doc, "docBDV", info.doc);
        return doc;
    }

    public static Document createForTimestamp(String source, long timestamp) {
        Document doc = new Document();
        DocumentFactory.addStringEntry(doc, "path", source, true);
        DocumentFactory.addLongEntry(doc, "timestampNDV", timestamp);
        return doc;
    }

    private static void addLongEntry(Document doc, String category, long value) {
        doc.add((IndexableField)new NumericDocValuesField(category, value));
    }

    private static void addStringEntry(Document doc, String category, String value, boolean store) {
        if (value == null) {
            return;
        }
        doc.add((IndexableField)new StringField(category, value, store ? Field.Store.YES : Field.Store.NO));
    }

    private static void addStringLCEntry(Document doc, String category, String value, boolean store) {
        DocumentFactory.addStringEntry(doc, category, value.toLowerCase(), store);
    }

    private static void addCCNameEntry(Document doc, String name) {
        String camelCaseName = null;
        StringBuilder camelCaseNameBuf = new StringBuilder();
        int i = 0;
        while (i < name.length()) {
            char ch = name.charAt(i);
            if (Character.isUpperCase(ch)) {
                camelCaseNameBuf.append(ch);
            } else if (i == 0) break;
            ++i;
        }
        camelCaseName = camelCaseNameBuf.length() > 0 ? camelCaseNameBuf.toString() : null;
        DocumentFactory.addStringEntry(doc, "ccName", camelCaseName, false);
    }

    private static void addBinaryEntry(Document doc, String category, String value) {
        if (value == null) {
            return;
        }
        doc.add((IndexableField)new BinaryDocValuesField(category, new BytesRef((CharSequence)value)));
    }
}

