/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ast;

import java.util.List;
import org.jruby.ast.Node;
import org.jruby.ast.RescueBodyNode;
import org.jruby.ast.visitor.NodeVisitor;
import org.jruby.evaluator.Instruction;
import org.jruby.lexer.yacc.ISourcePosition;

public class RescueNode
extends Node {
    static final long serialVersionUID = -4757038578511808125L;
    private final Node bodyNode;
    private final RescueBodyNode rescueNode;
    private final Node elseNode;

    public RescueNode(ISourcePosition position, Node bodyNode, RescueBodyNode rescueNode, Node elseNode) {
        super(position, 75);
        this.bodyNode = bodyNode;
        this.rescueNode = rescueNode;
        this.elseNode = elseNode;
    }

    @Override
    public Instruction accept(NodeVisitor iVisitor) {
        return iVisitor.visitRescueNode(this);
    }

    public Node getBodyNode() {
        return this.bodyNode;
    }

    public Node getElseNode() {
        return this.elseNode;
    }

    public RescueBodyNode getRescueNode() {
        return this.rescueNode;
    }

    @Override
    public List childNodes() {
        return Node.createList(this.rescueNode, this.bodyNode, this.elseNode);
    }

    public boolean isInline() {
        return false;
    }

    public static class Inline
    extends RescueNode {
        public Inline(ISourcePosition position, Node bodyNode, RescueBodyNode rescueNode, Node elseNode) {
            super(position, bodyNode, rescueNode, elseNode);
        }

        @Override
        public boolean isInline() {
            return true;
        }
    }
}

