/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.internal.debug.core.model;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.model.IDebugElement;
import org.eclipse.debug.core.model.IStackFrame;
import org.eclipse.debug.core.model.IThread;
import org.eclipse.dltk.core.DLTKCore;
import org.eclipse.dltk.dbgp.IDbgpFeature;
import org.eclipse.dltk.dbgp.IDbgpSession;
import org.eclipse.dltk.dbgp.IDbgpStreamFilter;
import org.eclipse.dltk.dbgp.IDbgpStreamListener;
import org.eclipse.dltk.dbgp.breakpoints.IDbgpBreakpoint;
import org.eclipse.dltk.dbgp.breakpoints.IDbgpLineBreakpoint;
import org.eclipse.dltk.dbgp.exceptions.DbgpException;
import org.eclipse.dltk.debug.core.DLTKDebugPlugin;
import org.eclipse.dltk.debug.core.DebugOption;
import org.eclipse.dltk.debug.core.IDebugOptions;
import org.eclipse.dltk.debug.core.model.IScriptDebugThreadConfigurator;
import org.eclipse.dltk.debug.core.model.IScriptStackFrame;
import org.eclipse.dltk.debug.core.model.IScriptThread;
import org.eclipse.dltk.internal.debug.core.model.DebugEventHelper;
import org.eclipse.dltk.internal.debug.core.model.IScriptStreamProxy;
import org.eclipse.dltk.internal.debug.core.model.IScriptThreadManager;
import org.eclipse.dltk.internal.debug.core.model.IScriptThreadManagerListener;
import org.eclipse.dltk.internal.debug.core.model.ScriptDebugTarget;
import org.eclipse.dltk.internal.debug.core.model.ScriptThread;
import org.eclipse.dltk.internal.debug.core.model.operations.DbgpDebugger;

public class ScriptThreadManager
implements IScriptThreadManager,
IDbgpStreamListener {
    private static final boolean DEBUG = DLTKCore.DEBUG;
    private IScriptDebugThreadConfigurator configurator = null;
    private final ListenerList listeners = new ListenerList(1);
    private final List<IScriptThread> threads = new ArrayList<IScriptThread>();
    private volatile boolean waitingForThreads = true;
    private final ScriptDebugTarget target;
    private IDbgpStreamFilter[] streamFilters = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean getThreadBoolean(IThreadBoolean b) {
        List<IScriptThread> list = this.threads;
        synchronized (list) {
            IScriptThread[] ths = this.getThreads();
            if (ths.length == 0) {
                return false;
            }
            int i = 0;
            while (true) {
                if (i >= ths.length) {
                    return true;
                }
                if (!b.get(ths[i])) {
                    return false;
                }
                ++i;
            }
        }
    }

    protected void fireThreadAccepted(IScriptThread thread, boolean first) {
        Object[] list = this.listeners.getListeners();
        int i = 0;
        while (i < list.length) {
            ((IScriptThreadManagerListener)list[i]).threadAccepted(thread, first);
            ++i;
        }
    }

    protected void fireAllThreadsTerminated() {
        Object[] list = this.listeners.getListeners();
        int i = 0;
        while (i < list.length) {
            ((IScriptThreadManagerListener)list[i]).allThreadsTerminated();
            ++i;
        }
    }

    @Override
    public void addListener(IScriptThreadManagerListener listener) {
        this.listeners.add((Object)listener);
    }

    @Override
    public void removeListener(IScriptThreadManagerListener listener) {
        this.listeners.remove((Object)listener);
    }

    @Override
    public boolean isWaitingForThreads() {
        return this.waitingForThreads;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean hasThreads() {
        List<IScriptThread> list = this.threads;
        synchronized (list) {
            return !this.threads.isEmpty();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IScriptThread[] getThreads() {
        List<IScriptThread> list = this.threads;
        synchronized (list) {
            return this.threads.toArray(new IScriptThread[this.threads.size()]);
        }
    }

    public ScriptThreadManager(ScriptDebugTarget target) {
        if (target == null) {
            throw new IllegalArgumentException();
        }
        this.target = target;
    }

    private String filter(String data, int stream) {
        if (this.streamFilters != null) {
            int i = 0;
            while (i < this.streamFilters.length) {
                if ((data = this.streamFilters[i].filter(data, stream)) == null) {
                    return null;
                }
                ++i;
            }
        }
        return data;
    }

    @Override
    public void stdoutReceived(String data) {
        IScriptStreamProxy proxy = this.target.getStreamProxy();
        if (proxy != null && (data = this.filter(data, 0)) != null) {
            proxy.writeStdout(data);
        }
        if (DEBUG) {
            System.out.println("Received (stdout): " + data);
        }
    }

    @Override
    public void stderrReceived(String data) {
        IScriptStreamProxy proxy = this.target.getStreamProxy();
        if (proxy != null && (data = this.filter(data, 1)) != null) {
            proxy.writeStderr(data);
        }
        if (DEBUG) {
            System.out.println("Received (stderr): " + data);
        }
    }

    void setStreamFilters(IDbgpStreamFilter[] streamFilters) {
        this.streamFilters = streamFilters;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static boolean hasBreakpointAtCurrentPosition(ScriptThread thread) {
        try {
            thread.updateStack();
            if (!thread.hasStackFrames()) return false;
            IStackFrame top = thread.getTopStackFrame();
            if (!(top instanceof IScriptStackFrame)) return false;
            if (top.getLineNumber() <= 0) return false;
            IScriptStackFrame frame = (IScriptStackFrame)top;
            if (frame.getSourceURI() == null) return false;
            String location = frame.getSourceURI().getPath();
            IDbgpBreakpoint[] breakpoints = thread.getDbgpSession().getCoreCommands().getBreakpoints();
            int i = 0;
            while (true) {
                block10: {
                    if (i >= breakpoints.length) {
                        return false;
                    }
                    if (breakpoints[i] instanceof IDbgpLineBreakpoint) {
                        IDbgpLineBreakpoint bp = (IDbgpLineBreakpoint)breakpoints[i];
                        if (frame.getLineNumber() == bp.getLineNumber()) {
                            try {
                                if (new URI(bp.getFilename()).getPath().equals(location)) {
                                    return true;
                                }
                            }
                            catch (URISyntaxException e) {
                                if (!DLTKCore.DEBUG) break block10;
                                e.printStackTrace();
                            }
                        }
                    }
                }
                ++i;
            }
        }
        catch (DebugException e) {
            if (!DLTKCore.DEBUG) return false;
            e.printStackTrace();
            return false;
        }
        catch (DbgpException e) {
            if (!DLTKCore.DEBUG) return false;
            e.printStackTrace();
        }
        return false;
    }

    private static boolean isValidStack(ScriptThread thread) {
        IDebugOptions debugOptions = thread.getDbgpSession().getDebugOptions();
        if (debugOptions.get(DebugOption.ENGINE_VALIDATE_STACK)) {
            thread.updateStack();
            if (thread.hasStackFrames()) {
                return thread.isValidStack();
            }
        }
        return true;
    }

    @Override
    public void acceptDbgpThread(IDbgpSession session, IProgressMonitor monitor) {
        SubMonitor sub = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        try {
            try {
                DbgpException error = session.getInfo().getError();
                if (error != null) {
                    throw error;
                }
                session.configure(this.target.getOptions());
                session.getStreamManager().addListener(this);
                boolean breakOnFirstLine = this.target.breakOnFirstLineEnabled() || this.isAnyThreadInStepInto();
                ScriptThread thread = new ScriptThread(this.target, session, this);
                thread.initialize((IProgressMonitor)sub.newChild(25));
                this.addThread(thread);
                boolean isFirstThread = this.waitingForThreads;
                if (isFirstThread) {
                    this.waitingForThreads = false;
                }
                if (isFirstThread || !ScriptThreadManager.isSupportsThreads(thread)) {
                    SubMonitor child = sub.newChild(25);
                    this.target.breakpointManager.initializeSession(thread.getDbgpSession(), (IProgressMonitor)child);
                    child = sub.newChild(25);
                    if (this.configurator != null) {
                        this.configurator.initializeBreakpoints(thread, (IProgressMonitor)child);
                    }
                }
                DebugEventHelper.fireCreateEvent(thread);
                boolean stopBeforeCode = thread.getDbgpSession().getDebugOptions().get(DebugOption.ENGINE_STOP_BEFORE_CODE);
                boolean executed = false;
                if (!breakOnFirstLine) {
                    if (stopBeforeCode || !ScriptThreadManager.hasBreakpointAtCurrentPosition(thread)) {
                        thread.resume();
                        executed = true;
                    }
                } else if (stopBeforeCode || !ScriptThreadManager.isValidStack(thread)) {
                    thread.initialStepInto();
                    executed = true;
                }
                if (!executed) {
                    if (!thread.isStackInitialized()) {
                        thread.updateStack();
                    }
                    DebugEventHelper.fireChangeEvent(thread);
                    DebugEventHelper.fireSuspendEvent(thread, 32);
                }
                sub.worked(25);
                this.fireThreadAccepted(thread, isFirstThread);
            }
            catch (Exception e) {
                try {
                    this.target.terminate();
                }
                catch (DebugException debugException) {
                    // empty catch block
                }
                DLTKDebugPlugin.log(e);
                sub.done();
            }
        }
        finally {
            sub.done();
        }
    }

    private static boolean isSupportsThreads(IScriptThread thread) {
        try {
            IDbgpFeature feature = thread.getDbgpSession().getCoreCommands().getFeature("language_supports_threads");
            return feature != null && "1".equals(feature.getValue());
        }
        catch (DbgpException e) {
            if (DLTKCore.DEBUG) {
                e.printStackTrace();
            }
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean isAnyThreadInStepInto() {
        List<IScriptThread> list = this.threads;
        synchronized (list) {
            ScriptThread thread;
            Iterator<IScriptThread> i = this.threads.iterator();
            do {
                if (i.hasNext()) continue;
                return false;
            } while (!(thread = (ScriptThread)i.next()).isStepInto());
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addThread(ScriptThread thread) {
        List<IScriptThread> list = this.threads;
        synchronized (list) {
            this.threads.add(thread);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void terminateThread(IScriptThread thread) {
        List<IScriptThread> list = this.threads;
        synchronized (list) {
            this.threads.remove(thread);
        }
        DebugEventHelper.fireTerminateEvent((IDebugElement)thread);
        IDbgpSession session = ((ScriptThread)thread).getDbgpSession();
        session.getStreamManager().removeListener(this);
        this.target.breakpointManager.removeSession(thread.getDbgpSession());
        if (!this.hasThreads()) {
            this.fireAllThreadsTerminated();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean canTerminate() {
        List<IScriptThread> list = this.threads;
        synchronized (list) {
            IScriptThread[] ths = this.getThreads();
            if (ths.length == 0) {
                return this.waitingForThreads;
                {
                }
            }
            int i = 0;
            while (true) {
                if (i >= ths.length) {
                    return true;
                }
                if (!ths[i].canTerminate()) {
                    return false;
                }
                ++i;
            }
        }
    }

    public boolean isTerminated() {
        if (!this.hasThreads()) {
            return !this.isWaitingForThreads();
        }
        return this.getThreadBoolean(thread -> thread.isTerminated());
    }

    public void terminate() throws DebugException {
        this.target.terminate();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void sendTerminationRequest() throws DebugException {
        List<IScriptThread> list = this.threads;
        synchronized (list) {
            IScriptThread[] threads = this.getThreads();
            int i = 0;
            while (i < threads.length) {
                threads[i].sendTerminationRequest();
                ++i;
            }
            this.waitingForThreads = false;
        }
    }

    public boolean canResume() {
        return this.getThreadBoolean(thread -> thread.canResume());
    }

    public boolean canSuspend() {
        return this.getThreadBoolean(thread -> thread.canSuspend());
    }

    public boolean isSuspended() {
        return this.getThreadBoolean(thread -> thread.isSuspended());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resume() throws DebugException {
        List<IScriptThread> list = this.threads;
        synchronized (list) {
            IScriptThread[] threads = this.getThreads();
            int i = 0;
            while (i < threads.length) {
                threads[i].resume();
                ++i;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void suspend() throws DebugException {
        List<IScriptThread> list = this.threads;
        synchronized (list) {
            IScriptThread[] threads = this.getThreads();
            int i = 0;
            while (i < threads.length) {
                threads[i].suspend();
                ++i;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void refreshThreads() {
        List<IScriptThread> list = this.threads;
        synchronized (list) {
            IScriptThread[] threads = this.getThreads();
            int i = 0;
            while (i < threads.length) {
                threads[i].updateStackFrames();
                ++i;
            }
        }
    }

    @Override
    public void setScriptThreadConfigurator(IScriptDebugThreadConfigurator configurator) {
        this.configurator = configurator;
    }

    @Override
    public void configureThread(DbgpDebugger engine, ScriptThread scriptThread) {
        if (this.configurator != null) {
            this.configurator.configureThread(engine, scriptThread);
        }
    }

    private static interface IThreadBoolean {
        public boolean get(IThread var1);
    }
}

