/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.javascript.internal.search;

import org.eclipse.dltk.core.IMember;
import org.eclipse.dltk.core.ISourceModule;
import org.eclipse.dltk.core.ISourceRange;
import org.eclipse.dltk.core.ModelException;
import org.eclipse.dltk.core.search.SearchPattern;
import org.eclipse.dltk.core.search.matching2.AbstractMatchingPredicate;
import org.eclipse.dltk.core.search.matching2.MatchLevel;
import org.eclipse.dltk.internal.core.search.matching.FieldPattern;
import org.eclipse.dltk.javascript.ast.Expression;
import org.eclipse.dltk.javascript.ast.Identifier;
import org.eclipse.dltk.javascript.internal.search.FieldDeclarationNode;
import org.eclipse.dltk.javascript.internal.search.FieldReferenceNode;
import org.eclipse.dltk.javascript.internal.search.MatchingNode;
import org.eclipse.dltk.javascript.internal.search.MemberReferenceNode;
import org.eclipse.dltk.javascript.typeinference.ReferenceLocation;

public class FieldPredicate
extends AbstractMatchingPredicate<MatchingNode> {
    private final boolean declarations;
    private final boolean references;
    private final ISourceModule module;
    private final int nameStart;
    private final int nameEnd;

    public FieldPredicate(FieldPattern pattern) {
        super((SearchPattern)pattern, pattern.name);
        this.declarations = pattern.findDeclarations;
        this.references = pattern.findReferences;
        ISourceRange nameRange = null;
        if (pattern.focus instanceof IMember) {
            try {
                nameRange = ((IMember)pattern.focus).getNameRange();
            }
            catch (ModelException modelException) {
                // empty catch block
            }
        }
        if (nameRange != null) {
            this.nameStart = nameRange.getOffset();
            this.nameEnd = this.nameStart + nameRange.getLength();
            this.module = pattern.focus != null ? (ISourceModule)pattern.focus.getAncestor(5) : null;
        } else {
            this.nameStart = -1;
            this.nameEnd = -1;
            this.module = null;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public MatchLevel match(MatchingNode node) {
        if (node instanceof FieldDeclarationNode) {
            if (!this.declarations) {
                return null;
            }
            FieldDeclarationNode fieldNode = (FieldDeclarationNode)node;
            return this.matchName(fieldNode.getName());
        }
        if (!(node instanceof FieldReferenceNode)) return null;
        if (!this.references) {
            return null;
        }
        FieldReferenceNode fieldNode = (FieldReferenceNode)node;
        if (this.nameStart == -1 || this.nameEnd == -1) return this.matchName(((Identifier)fieldNode.node).getName(), MatchLevel.INACCURATE_MATCH);
        ReferenceLocation location = fieldNode.location;
        if (location == null) return this.matchName(((Identifier)fieldNode.node).getName());
        if (location.getNameStart() != this.nameStart || location.getNameEnd() != this.nameEnd || !this.isSame(location.getSourceModule())) return null;
        return this.matchName(((Identifier)fieldNode.node).getName(), MatchLevel.ACCURATE_MATCH);
    }

    public MatchLevel resolvePotentialMatch(MatchingNode node) {
        if (this.nameStart != -1 && this.nameEnd != -1) {
            Expression exp;
            if (node instanceof MemberReferenceNode) {
                MemberReferenceNode mNode = (MemberReferenceNode)node;
                ReferenceLocation location = mNode.location;
                return location != null && location.getNameStart() == this.nameStart && location.getNameEnd() == this.nameEnd && this.isSame(location.getSourceModule()) ? MatchLevel.ACCURATE_MATCH : null;
            }
            if (node instanceof FieldDeclarationNode && (exp = (Expression)((FieldDeclarationNode)node).node) != null && exp.sourceStart() == this.nameStart && exp.sourceEnd() == this.nameEnd && this.isSame(((FieldDeclarationNode)node).module)) {
                return MatchLevel.ACCURATE_MATCH;
            }
        }
        return super.resolvePotentialMatch((Object)node);
    }

    private boolean isSame(ISourceModule module) {
        return module != null && module.equals(this.module);
    }
}

