/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.sh.internal.ui.text.folding;

import org.eclipse.dltk.core.IMethod;
import org.eclipse.dltk.core.IModelElement;
import org.eclipse.dltk.sh.internal.ui.text.folding.FoldingBlockKind;
import org.eclipse.dltk.ui.text.folding.IFoldingBlockKind;
import org.eclipse.dltk.ui.text.folding.ModelFoldingBlockProvider;
import org.eclipse.jface.preference.IPreferenceStore;

public class ShellCodeFoldingBlockProvider
extends ModelFoldingBlockProvider {
    private int minimalLineCount;
    private boolean foldingEnabled;
    private boolean functionsCollapsedInitially;

    public boolean visit(IModelElement element) {
        if (element instanceof IMethod) {
            this.reportElement(element);
        }
        return true;
    }

    public void initializePreferences(IPreferenceStore preferenceStore) {
        super.initializePreferences(preferenceStore);
        this.minimalLineCount = preferenceStore.getInt("editor_folding_lines_limit");
        this.foldingEnabled = preferenceStore.getBoolean("editor_folding_enabled");
        this.functionsCollapsedInitially = preferenceStore.getBoolean("editor_folding_init_methods");
    }

    public int getMinimalLineCount() {
        return this.minimalLineCount;
    }

    protected boolean isFoldedInitially(IModelElement element) {
        if (this.foldingEnabled && element instanceof IMethod) {
            return this.functionsCollapsedInitially;
        }
        return false;
    }

    protected IFoldingBlockKind getKind(IModelElement element) {
        if (element instanceof IMethod) {
            return FoldingBlockKind.FUNCTION;
        }
        return null;
    }
}

