/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.internal.core;

import java.util.ArrayList;
import org.eclipse.dltk.core.IField;
import org.eclipse.dltk.core.IMethod;
import org.eclipse.dltk.core.IScriptFolder;
import org.eclipse.dltk.core.IType;
import org.eclipse.dltk.internal.core.IModelElementRequestor;

public class ModelElementRequestor
implements IModelElementRequestor {
    protected boolean fCanceled = false;
    protected ArrayList fFields = null;
    protected ArrayList fInitializers = null;
    protected ArrayList fMemberTypes = null;
    protected ArrayList fMethods = null;
    protected ArrayList fScriptFolders = null;
    protected ArrayList fTypes = null;
    protected static IField[] fgEmptyFieldArray = new IField[0];
    protected static IType[] fgEmptyTypeArray = new IType[0];
    protected static IScriptFolder[] fgEmptyScriptFolderArray = new IScriptFolder[0];
    protected static IMethod[] fgEmptyMethodArray = new IMethod[0];

    @Override
    public void acceptField(IField field) {
        if (this.fFields == null) {
            this.fFields = new ArrayList();
        }
        this.fFields.add(field);
    }

    @Override
    public void acceptMemberType(IType type) {
        if (this.fMemberTypes == null) {
            this.fMemberTypes = new ArrayList();
        }
        this.fMemberTypes.add(type);
    }

    @Override
    public void acceptMethod(IMethod method) {
        if (this.fMethods == null) {
            this.fMethods = new ArrayList();
        }
        this.fMethods.add(method);
    }

    @Override
    public void acceptScriptFolder(IScriptFolder ScriptFolder2) {
        if (this.fScriptFolders == null) {
            this.fScriptFolders = new ArrayList();
        }
        this.fScriptFolders.add(ScriptFolder2);
    }

    @Override
    public void acceptType(IType type) {
        if (this.fTypes == null) {
            this.fTypes = new ArrayList();
        }
        this.fTypes.add(type);
    }

    public IField[] getFields() {
        if (this.fFields == null) {
            return fgEmptyFieldArray;
        }
        int size = this.fFields.size();
        IField[] results = new IField[size];
        this.fFields.toArray(results);
        return results;
    }

    public IType[] getMemberTypes() {
        if (this.fMemberTypes == null) {
            return fgEmptyTypeArray;
        }
        int size = this.fMemberTypes.size();
        IType[] results = new IType[size];
        this.fMemberTypes.toArray(results);
        return results;
    }

    public IMethod[] getMethods() {
        if (this.fMethods == null) {
            return fgEmptyMethodArray;
        }
        int size = this.fMethods.size();
        IMethod[] results = new IMethod[size];
        this.fMethods.toArray(results);
        return results;
    }

    public IScriptFolder[] getScriptFolders() {
        if (this.fScriptFolders == null) {
            return fgEmptyScriptFolderArray;
        }
        int size = this.fScriptFolders.size();
        IScriptFolder[] results = new IScriptFolder[size];
        this.fScriptFolders.toArray(results);
        return results;
    }

    public IType[] getTypes() {
        if (this.fTypes == null) {
            return fgEmptyTypeArray;
        }
        int size = this.fTypes.size();
        IType[] results = new IType[size];
        this.fTypes.toArray(results);
        return results;
    }

    @Override
    public boolean isCanceled() {
        return this.fCanceled;
    }

    public void reset() {
        this.fCanceled = false;
        this.fFields = null;
        this.fInitializers = null;
        this.fMemberTypes = null;
        this.fMethods = null;
        this.fScriptFolders = null;
        this.fTypes = null;
    }

    public void setCanceled(boolean b) {
        this.fCanceled = b;
    }
}

