/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.rhino.dbgp;

import java.io.File;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.HashMap;
import org.eclipse.dltk.rhino.dbgp.Base64Helper;

public class BreakPoint {
    static int last_id = 0;
    protected final String file;
    protected int line;
    protected final int id;
    protected boolean enabled = true;
    protected boolean isTemporary = false;
    protected int hitValue = 0;
    protected int hitCondition = 0;
    protected int currentHitCount = 0;
    protected String expression;
    protected boolean isExitBreakpoint;
    protected String method;
    protected boolean isReturn;
    protected boolean isWatch;
    protected boolean isCall;
    protected boolean isModification;
    protected boolean isAccess;
    private String type;

    protected BreakPoint(HashMap options) {
        String hitValue;
        String uri;
        String object;
        this.type = object = (String)options.get("-t");
        if (object.equals("call") || object.equals("return")) {
            this.method = (String)options.get("-m");
            this.isReturn = object.equals("return");
            this.isCall = object.equals("call");
        }
        if (object.equals("watch")) {
            this.isWatch = true;
        }
        if ((uri = (String)options.get("-f")) != null) {
            try {
                this.file = new File(new URI(uri)).getAbsolutePath();
            }
            catch (URISyntaxException e) {
                throw new RuntimeException();
            }
        } else {
            this.file = "";
        }
        String line = (String)options.get("-n");
        this.line = line != null ? Integer.parseInt(line) : -1;
        String tm = (String)options.get("-r");
        if (tm != null) {
            this.isTemporary = tm.equals("1");
        }
        if ((hitValue = (String)options.get("-h")) != null) {
            this.hitValue = Integer.parseInt(hitValue);
        }
        String hitCondition = (String)options.get("-o");
        this.setHitCondition(hitCondition);
        String exp = (String)options.get("--");
        String disable = (String)options.get("-s");
        if (disable.equals("disabled")) {
            this.setEnabled(false);
        }
        if (exp != null) {
            this.expression = Base64Helper.decodeString(exp);
            if (this.expression != null) {
                this.expression = this.expression.trim();
            }
        }
        if (this.isWatch) {
            this.isModification = this.expression.charAt(this.expression.length() - 1) == '1';
            this.isAccess = this.expression.charAt(this.expression.length() - 2) == '1';
            this.expression = this.expression.substring(0, this.expression.length() - 2);
        }
        this.id = last_id++;
    }

    protected void setHitCondition(String hitCondition) {
        if (hitCondition != null) {
            if (hitCondition.equals(">=")) {
                this.hitCondition = 1;
            }
            if (hitCondition.equals("==")) {
                this.hitCondition = 2;
            }
            if (hitCondition.equals("%")) {
                this.hitCondition = 3;
            }
        }
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.file == null ? 0 : this.file.hashCode());
        result = 31 * result + this.line;
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        BreakPoint other = (BreakPoint)obj;
        if (this.file == null ? other.file != null : !this.file.equals(other.file)) {
            return false;
        }
        return this.line == other.line;
    }

    protected boolean isEnabled() {
        return this.enabled;
    }

    protected void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public String getType() {
        return this.type;
    }

    public String getState() {
        return "";
    }

    public String getHitCondition() {
        if (this.hitCondition == 1) {
            return ">=";
        }
        if (this.hitCondition == 2) {
            return "==";
        }
        if (this.hitCondition == 3) {
            return "%";
        }
        return "==";
    }
}

