/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.internal.corext.refactoring.reorg;

import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.Assert;
import org.eclipse.dltk.core.DLTKCore;
import org.eclipse.dltk.core.IMember;
import org.eclipse.dltk.core.IMethod;
import org.eclipse.dltk.core.IModelElement;
import org.eclipse.dltk.core.IProjectFragment;
import org.eclipse.dltk.core.IScriptFolder;
import org.eclipse.dltk.core.IScriptProject;
import org.eclipse.dltk.core.ISourceModule;
import org.eclipse.dltk.core.ModelException;
import org.eclipse.dltk.core.ScriptModelUtil;
import org.eclipse.dltk.internal.core.ExternalSourceModule;
import org.eclipse.dltk.internal.corext.refactoring.RefactoringCoreMessages;
import org.eclipse.dltk.internal.corext.refactoring.util.ModelElementUtil;
import org.eclipse.dltk.internal.corext.refactoring.util.ResourceUtil;
import org.eclipse.dltk.internal.corext.util.Messages;
import org.eclipse.ui.IWorkingSet;

public class ReorgUtils {
    public static boolean containsOnlyProjects(List elements) {
        if (elements.isEmpty()) {
            return false;
        }
        Iterator iter = elements.iterator();
        while (iter.hasNext()) {
            if (ReorgUtils.isProject(iter.next())) continue;
            return false;
        }
        return true;
    }

    public static boolean isProject(Object element) {
        return element instanceof IScriptProject || element instanceof IProject;
    }

    public static boolean isInsideSourceModule(IModelElement element) {
        return !(element instanceof ISourceModule) && ReorgUtils.hasAncestorOfType(element, 5);
    }

    public static boolean hasAncestorOfType(IModelElement element, int type) {
        return element.getAncestor(type) != null;
    }

    public static ISourceModule getSourceModule(IModelElement modelElement) {
        if (modelElement instanceof ISourceModule) {
            return (ISourceModule)modelElement;
        }
        return (ISourceModule)modelElement.getAncestor(5);
    }

    public static boolean isDeletedFromEditor(IModelElement elem) {
        if (!ReorgUtils.isInsideSourceModule(elem)) {
            return false;
        }
        if (elem instanceof IMember) {
            return false;
        }
        ISourceModule cu = ReorgUtils.getSourceModule(elem);
        if (cu == null) {
            return false;
        }
        ISourceModule wc = cu;
        if (cu.equals(wc)) {
            return false;
        }
        IModelElement wcElement = ScriptModelUtil.findInSourceModule((ISourceModule)wc, (IModelElement)elem);
        return wcElement == null || !wcElement.exists();
    }

    public static String getName(IModelElement element) throws ModelException {
        String pattern = ReorgUtils.createNamePattern(element);
        Object[] args = ReorgUtils.createNameArguments(element);
        return Messages.format(pattern, args);
    }

    public static String getName(IResource resource) {
        String pattern = ReorgUtils.createNamePattern(resource);
        Object[] args = ReorgUtils.createNameArguments(resource);
        return Messages.format(pattern, args);
    }

    private static String[] createNameArguments(IResource resource) {
        return new String[]{resource.getName()};
    }

    private static String createNamePattern(IResource resource) {
        switch (resource.getType()) {
            case 1: {
                return RefactoringCoreMessages.ReorgUtils_0;
            }
            case 2: {
                return RefactoringCoreMessages.ReorgUtils_1;
            }
            case 4: {
                return RefactoringCoreMessages.ReorgUtils_2;
            }
        }
        Assert.isTrue((boolean)false);
        return null;
    }

    private static String createNamePattern(IModelElement element) throws ModelException {
        switch (element.getElementType()) {
            case 5: {
                if (element instanceof ExternalSourceModule) {
                    return RefactoringCoreMessages.ReorgUtils_21;
                }
                return RefactoringCoreMessages.ReorgUtils_4;
            }
            case 8: {
                return RefactoringCoreMessages.ReorgUtils_5;
            }
            case 2: {
                return RefactoringCoreMessages.ReorgUtils_9;
            }
            case 9: {
                if (((IMethod)element).isConstructor()) {
                    return RefactoringCoreMessages.ReorgUtils_10;
                }
                return RefactoringCoreMessages.ReorgUtils_11;
            }
            case 4: {
                if (ModelElementUtil.isDefaultPackage(element)) {
                    return RefactoringCoreMessages.ReorgUtils_13;
                }
                return RefactoringCoreMessages.ReorgUtils_14;
            }
            case 3: {
                if (ReorgUtils.isSourceFolder(element)) {
                    return RefactoringCoreMessages.ReorgUtils_15;
                }
                return RefactoringCoreMessages.ReorgUtils_17;
            }
            case 7: {
                return RefactoringCoreMessages.ReorgUtils_18;
            }
        }
        Assert.isTrue((boolean)false);
        return null;
    }

    private static String[] createNameArguments(IModelElement element) throws ModelException {
        switch (element.getElementType()) {
            case 5: {
                if (element instanceof ExternalSourceModule) {
                    return new String[]{((ExternalSourceModule)element).getFullPath().toString()};
                }
                return new String[]{element.getElementName()};
            }
            case 8: {
                return new String[]{element.getElementName()};
            }
            case 2: {
                return new String[]{element.getElementName()};
            }
            case 9: {
                return new String[]{element.getElementName()};
            }
            case 4: {
                return new String[]{element.getElementName()};
            }
            case 3: {
                return new String[]{element.getElementName()};
            }
            case 7: {
                return new String[]{element.getElementName()};
            }
        }
        Assert.isTrue((boolean)false);
        return null;
    }

    public static boolean isSourceFolder(IModelElement modelElement) throws ModelException {
        return modelElement instanceof IProjectFragment && ((IProjectFragment)modelElement).getKind() == 1;
    }

    public static IResource[] getResources(List elements) {
        ArrayList<IResource> resources = new ArrayList<IResource>(elements.size());
        for (Object element : elements) {
            if (!(element instanceof IResource)) continue;
            resources.add((IResource)element);
        }
        return resources.toArray(new IResource[resources.size()]);
    }

    public static IResource getResource(IModelElement element) {
        if (element instanceof ISourceModule) {
            return ((ISourceModule)element).getPrimary().getResource();
        }
        return element.getResource();
    }

    public static IResource[] getResources(IModelElement[] elements) {
        ArrayList<IResource> resultArray = new ArrayList<IResource>();
        int i = 0;
        while (i < elements.length) {
            IResource res = ReorgUtils.getResource(elements[i]);
            if (res != null) {
                resultArray.add(res);
            }
            ++i;
        }
        return resultArray.toArray(new IResource[resultArray.size()]);
    }

    public static IResource[] getNotLinked(IResource[] resources) {
        ArrayList<IResource> result = new ArrayList<IResource>(resources.length);
        int i = 0;
        while (i < resources.length) {
            IResource resource = resources[i];
            if (resource != null && !result.contains(resource) && !resource.isLinked()) {
                result.add(resource);
            }
            ++i;
        }
        return result.toArray(new IResource[result.size()]);
    }

    public static IResource[] getNotNulls(IResource[] resources) {
        ArrayList<IResource> result = new ArrayList<IResource>(resources.length);
        int i = 0;
        while (i < resources.length) {
            IResource resource = resources[i];
            if (resource != null && !result.contains(resource)) {
                result.add(resource);
            }
            ++i;
        }
        return result.toArray(new IResource[result.size()]);
    }

    public static Map groupBySourceModule(List modelElements) {
        HashMap result = new HashMap();
        for (IModelElement element : modelElements) {
            ISourceModule cu = ReorgUtils.getSourceModule(element);
            if (cu == null) continue;
            if (!result.containsKey(cu)) {
                result.put(cu, new ArrayList(1));
            }
            ((List)result.get(cu)).add(element);
        }
        return result;
    }

    public static List getElementsOfType(IModelElement[] modelElements, int type) {
        ArrayList<IModelElement> result = new ArrayList<IModelElement>(modelElements.length);
        int i = 0;
        while (i < modelElements.length) {
            if (ReorgUtils.isOfType(modelElements[i], type)) {
                result.add(modelElements[i]);
            }
            ++i;
        }
        return result;
    }

    private static boolean isOfType(IModelElement element, int type) {
        return element.getElementType() == type;
    }

    private static boolean isOfType(IResource resource, int type) {
        return resource != null && ReorgUtils.isFlagSet(resource.getType(), type);
    }

    private static boolean isFlagSet(int flags, int flag) {
        return (flags & flag) != 0;
    }

    public static IModelElement[] setMinus(IModelElement[] setToRemoveFrom, IModelElement[] elementsToRemove) {
        HashSet<IModelElement> setMinus = new HashSet<IModelElement>(setToRemoveFrom.length - setToRemoveFrom.length);
        setMinus.addAll(Arrays.asList(setToRemoveFrom));
        setMinus.removeAll(Arrays.asList(elementsToRemove));
        return setMinus.toArray(new IModelElement[setMinus.size()]);
    }

    public static IModelElement[] union(IModelElement[] set1, IModelElement[] set2) {
        ArrayList union = new ArrayList(set1.length + set2.length);
        ReorgUtils.addAll(set1, union);
        ReorgUtils.addAll(set2, union);
        return union.toArray(new IModelElement[union.size()]);
    }

    public static IResource[] union(IResource[] set1, IResource[] set2) {
        ArrayList union = new ArrayList(set1.length + set2.length);
        ReorgUtils.addAll(ReorgUtils.getNotNulls(set1), union);
        ReorgUtils.addAll(ReorgUtils.getNotNulls(set2), union);
        return union.toArray(new IResource[union.size()]);
    }

    private static void addAll(Object[] array, List list) {
        int i = 0;
        while (i < array.length) {
            if (!list.contains(array[i])) {
                list.add(array[i]);
            }
            ++i;
        }
    }

    public static IResource[] setMinus(IResource[] setToRemoveFrom, IResource[] elementsToRemove) {
        HashSet<IResource> setMinus = new HashSet<IResource>(setToRemoveFrom.length - setToRemoveFrom.length);
        setMinus.addAll(Arrays.asList(setToRemoveFrom));
        setMinus.removeAll(Arrays.asList(elementsToRemove));
        return setMinus.toArray(new IResource[setMinus.size()]);
    }

    public static IModelElement[] getModelElements(List elements) {
        ArrayList<IModelElement> resources = new ArrayList<IModelElement>(elements.size());
        for (Object element : elements) {
            if (!(element instanceof IModelElement)) continue;
            resources.add((IModelElement)element);
        }
        return resources.toArray(new IModelElement[resources.size()]);
    }

    public static ISourceModule[] getSourceModules(IModelElement[] modelElements) {
        ISourceModule[] result = new ISourceModule[modelElements.length];
        int i = 0;
        while (i < modelElements.length) {
            result[i] = ReorgUtils.getSourceModule(modelElements[i]);
            ++i;
        }
        return result;
    }

    public static IWorkingSet[] getWorkingSets(List elements) {
        ArrayList<IWorkingSet> result = new ArrayList<IWorkingSet>(1);
        for (Object element : elements) {
            if (!(element instanceof IWorkingSet)) continue;
            result.add((IWorkingSet)element);
        }
        return result.toArray(new IWorkingSet[result.size()]);
    }

    public static void splitIntoModelElementsAndResources(Object[] elements, List modelElementResult, List resourceResult) {
        int i = 0;
        while (i < elements.length) {
            Object element = elements[i];
            if (element instanceof IModelElement) {
                modelElementResult.add(element);
            } else if (element instanceof IResource) {
                IResource resource = (IResource)element;
                IModelElement jElement = DLTKCore.create((IResource)resource);
                if (jElement != null && jElement.exists()) {
                    modelElementResult.add(jElement);
                } else {
                    resourceResult.add(resource);
                }
            }
            ++i;
        }
    }

    public static boolean containsElementOrParent(Set elements, IModelElement element) {
        if (elements.contains(element)) {
            return true;
        }
        IModelElement parent = element.getParent();
        while (parent != null) {
            if (elements.contains(parent)) {
                return true;
            }
            parent = parent.getParent();
        }
        return false;
    }

    public static boolean containsElementOrParent(Set elements, IResource element) {
        if (elements.contains(element)) {
            return true;
        }
        IContainer parent = element.getParent();
        while (parent != null) {
            if (elements.contains(parent)) {
                return true;
            }
            IModelElement parentAsScriptElement = DLTKCore.create((IResource)parent);
            if (parentAsScriptElement != null && parentAsScriptElement.exists() && elements.contains(parentAsScriptElement)) {
                return true;
            }
            parent = parent.getParent();
        }
        return false;
    }

    public static boolean hasElementsNotOfType(IResource[] resources, int typeMask) {
        int i = 0;
        while (i < resources.length) {
            IResource resource = resources[i];
            if (resource != null && !ReorgUtils.isOfType(resource, typeMask)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public static boolean hasElementsNotOfType(IModelElement[] modelElements, int type) {
        int i = 0;
        while (i < modelElements.length) {
            IModelElement element = modelElements[i];
            if (element != null && !ReorgUtils.isOfType(element, type)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public static boolean canBeDestinationForLinkedResources(IResource resource) {
        return resource.isAccessible() && resource instanceof IProject;
    }

    public static boolean canBeDestinationForLinkedResources(IModelElement modelElement) {
        if (modelElement instanceof IProjectFragment) {
            return ReorgUtils.isProjectFragmentCorrespondingToProject((IProjectFragment)modelElement);
        }
        return modelElement instanceof IScriptProject;
    }

    private static boolean isProjectFragmentCorrespondingToProject(IProjectFragment root) {
        return root.getResource() instanceof IProject;
    }

    public static boolean isArchiveOrExterrnalMember(IModelElement[] elements) {
        int i = 0;
        while (i < elements.length) {
            IModelElement element = elements[i];
            IProjectFragment root = (IProjectFragment)element.getAncestor(3);
            if (root != null && (root.isArchive() || root.isExternal())) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public static boolean hasElementsOfType(IModelElement[] modelElements, int type) {
        int i = 0;
        while (i < modelElements.length) {
            IModelElement element = modelElements[i];
            if (element != null && ReorgUtils.isOfType(element, type)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public static boolean hasElementsOfType(IModelElement[] modelElements, int[] types) {
        int i = 0;
        while (i < types.length) {
            if (ReorgUtils.hasElementsOfType(modelElements, types[i])) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public static boolean hasElementsOfType(IResource[] resources, int typeMask) {
        int i = 0;
        while (i < resources.length) {
            IResource resource = resources[i];
            if (resource != null && ReorgUtils.isOfType(resource, typeMask)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public static IFile[] getFiles(IResource[] resources) {
        Set result = ReorgUtils.getResourcesOfType(resources, 1);
        return result.toArray(new IFile[result.size()]);
    }

    public static Set getResourcesOfType(IResource[] resources, int typeMask) {
        HashSet<IResource> result = new HashSet<IResource>(resources.length);
        int i = 0;
        while (i < resources.length) {
            if (ReorgUtils.isOfType(resources[i], typeMask)) {
                result.add(resources[i]);
            }
            ++i;
        }
        return result;
    }

    public static IFolder[] getFolders(IResource[] resources) {
        Set result = ReorgUtils.getResourcesOfType(resources, 2);
        return result.toArray(new IFolder[result.size()]);
    }

    public static IProjectFragment getCorrespondingProjectFragment(IScriptProject p) throws ModelException {
        IProjectFragment[] roots = p.getProjectFragments();
        int i = 0;
        while (i < roots.length) {
            if (ReorgUtils.isProjectFragmentCorrespondingToProject(roots[i])) {
                return roots[i];
            }
            ++i;
        }
        return null;
    }

    public static boolean containsLinkedResources(IResource[] resources) {
        int i = 0;
        while (i < resources.length) {
            if (resources[i] != null && resources[i].isLinked()) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public static boolean containsLinkedResources(IModelElement[] modelElements) {
        int i = 0;
        while (i < modelElements.length) {
            IResource res = ReorgUtils.getResource(modelElements[i]);
            if (res != null && res.isLinked()) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public static boolean isProjectFragment(IScriptProject scriptProject) throws ModelException {
        return ReorgUtils.getCorrespondingProjectFragment(scriptProject) != null;
    }

    public static boolean areEqualInWorkspaceOrOnDisk(IResource r1, IResource r2) {
        if (r1 == null || r2 == null) {
            return false;
        }
        if (r1.equals((Object)r2)) {
            return true;
        }
        URI r1Location = r1.getLocationURI();
        URI r2Location = r2.getLocationURI();
        if (r1Location == null || r2Location == null) {
            return false;
        }
        return r1Location.equals(r2Location);
    }

    public static boolean isParentInWorkspaceOrOnDisk(IScriptFolder pack, IProjectFragment root) {
        if (pack == null) {
            return false;
        }
        IModelElement packParent = pack.getParent();
        if (packParent == null) {
            return false;
        }
        if (packParent.equals(root)) {
            return true;
        }
        IResource packageResource = ResourceUtil.getResource((Object)pack);
        IResource packageRootResource = ResourceUtil.getResource((Object)root);
        return ReorgUtils.isParentInWorkspaceOrOnDisk(packageResource, packageRootResource);
    }

    public static boolean isParentInWorkspaceOrOnDisk(IProjectFragment root, IScriptProject scriptProject) {
        if (root == null) {
            return false;
        }
        IModelElement rootParent = root.getParent();
        if (rootParent == null) {
            return false;
        }
        if (rootParent.equals(root)) {
            return true;
        }
        IResource packageResource = ResourceUtil.getResource((Object)root);
        IResource packageRootResource = ResourceUtil.getResource((Object)scriptProject);
        return ReorgUtils.isParentInWorkspaceOrOnDisk(packageResource, packageRootResource);
    }

    public static boolean isParentInWorkspaceOrOnDisk(ISourceModule cu, IScriptFolder dest) {
        if (cu == null) {
            return false;
        }
        IModelElement cuParent = cu.getParent();
        if (cuParent == null) {
            return false;
        }
        if (cuParent.equals(dest)) {
            return true;
        }
        IResource cuResource = ResourceUtil.getResource((ISourceModule)cu);
        IResource packageResource = ResourceUtil.getResource((Object)dest);
        return ReorgUtils.isParentInWorkspaceOrOnDisk(cuResource, packageResource);
    }

    public static boolean isParentInWorkspaceOrOnDisk(IResource res, IResource maybeParent) {
        if (res == null) {
            return false;
        }
        return ReorgUtils.areEqualInWorkspaceOrOnDisk((IResource)res.getParent(), maybeParent);
    }
}

