/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.ui.text;

import org.eclipse.core.resources.IMarker;
import org.eclipse.dltk.ui.editor.IScriptAnnotation;
import org.eclipse.dltk.ui.text.IScriptCorrectionProcessor;
import org.eclipse.dltk.utils.NatureExtensionManager;
import org.eclipse.jface.text.source.Annotation;
import org.eclipse.ui.texteditor.SimpleMarkerAnnotation;

public class ScriptCorrectionProcessorManager
extends NatureExtensionManager {
    private static final String EXT_POINT = "org.eclipse.dltk.ui.correctionProcessor";
    private static ScriptCorrectionProcessorManager instance = null;

    private ScriptCorrectionProcessorManager() {
        super(EXT_POINT, IScriptCorrectionProcessor.class);
    }

    private static synchronized ScriptCorrectionProcessorManager getInstance() {
        if (instance == null) {
            instance = new ScriptCorrectionProcessorManager();
        }
        return instance;
    }

    public static IScriptCorrectionProcessor[] getProcessors(String natureId) {
        return (IScriptCorrectionProcessor[])ScriptCorrectionProcessorManager.getInstance().getInstances(natureId);
    }

    public static boolean canFix(String natureId, Annotation annotation) {
        block6: {
            IScriptCorrectionProcessor[] processors;
            block5: {
                processors = ScriptCorrectionProcessorManager.getProcessors(natureId);
                if (processors == null) {
                    return false;
                }
                if (!(annotation instanceof IScriptAnnotation)) break block5;
                IScriptAnnotation sa = (IScriptAnnotation)annotation;
                int i = 0;
                while (i < processors.length) {
                    if (processors[i].canFix(sa)) {
                        return true;
                    }
                    ++i;
                }
                break block6;
            }
            if (!(annotation instanceof SimpleMarkerAnnotation)) break block6;
            IMarker marker = ((SimpleMarkerAnnotation)annotation).getMarker();
            int i = 0;
            while (i < processors.length) {
                if (processors[i].canFix(marker)) {
                    return true;
                }
                ++i;
            }
        }
        return false;
    }
}

