/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.itcl.internal.core.parser.structure;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.dltk.compiler.IElementRequestor;
import org.eclipse.dltk.itcl.internal.core.parser.structure.CommandImpl;
import org.eclipse.dltk.itcl.internal.core.parser.structure.ICommand;
import org.eclipse.dltk.itcl.internal.core.parser.structure.IncrTclNames;
import org.eclipse.dltk.itcl.internal.core.parser.structure.PrefixedCommandImpl;
import org.eclipse.dltk.itcl.internal.core.parser.structure.model.IClass;
import org.eclipse.dltk.itcl.internal.core.parser.structure.model.IMember;
import org.eclipse.dltk.itcl.internal.core.parser.structure.model.IMethod;
import org.eclipse.dltk.itcl.internal.core.parser.structure.model.IVariable;
import org.eclipse.dltk.itcl.internal.core.parser.structure.model.impl.ClassImpl;
import org.eclipse.dltk.itcl.internal.core.parser.structure.model.impl.Method;
import org.eclipse.dltk.itcl.internal.core.parser.structure.model.impl.Variable;
import org.eclipse.dltk.tcl.ast.Node;
import org.eclipse.dltk.tcl.ast.Script;
import org.eclipse.dltk.tcl.ast.TclArgument;
import org.eclipse.dltk.tcl.ast.TclCommand;
import org.eclipse.dltk.tcl.structure.AbstractTclCommandModelBuilder;
import org.eclipse.dltk.tcl.structure.ITclModelBuildContext;
import org.eclipse.dltk.tcl.structure.ITclTypeHandler;
import org.eclipse.dltk.tcl.structure.ITclTypeResolver;
import org.eclipse.dltk.tcl.structure.TclModelProblem;

public class IncrTclClass
extends AbstractTclCommandModelBuilder {
    private Map<String, Handler> handlers = new HashMap<String, Handler>();

    public IncrTclClass() {
        this.handlers.put("inherit", (clazz, command, context) -> this.handleInherit(clazz, command));
        this.handlers.put("constructor", (clazz, command, context) -> this.handleConstructor(clazz, command));
        this.handlers.put("destructor", (clazz, command, context) -> this.handleDestructor(clazz, command));
        this.handlers.put("method", (clazz, command, context) -> this.handleProc(clazz, command, IMethod.MethodKind.METHOD));
        this.handlers.put("proc", (clazz, command, context) -> this.handleProc(clazz, command, IMethod.MethodKind.PROC));
        this.handlers.put("variable", (clazz, command, context) -> this.handleVariable(clazz, command, IVariable.VariableKind.VARIABLE));
        this.handlers.put("common", (clazz, command, context) -> this.handleVariable(clazz, command, IVariable.VariableKind.COMMON));
        this.handlers.put("public", (clazz, command, context) -> this.handleVisibility(clazz, command, context, IMember.Visibility.PUBLIC));
        this.handlers.put("protected", (clazz, command, context) -> this.handleVisibility(clazz, command, context, IMember.Visibility.PROTECTED));
        this.handlers.put("private", (clazz, command, context) -> this.handleVisibility(clazz, command, context, IMember.Visibility.PRIVATE));
    }

    public boolean process(TclCommand command, ITclModelBuildContext context) throws TclModelProblem {
        if (command.getArguments().size() != 2) {
            return false;
        }
        TclArgument className = (TclArgument)command.getArguments().get(0);
        if (!IncrTclClass.isSymbol((TclArgument)className)) {
            return false;
        }
        ClassImpl clazz = new ClassImpl();
        Script classBody = context.parse((TclArgument)command.getArguments().get(1), 1);
        this.processContent((IClass)clazz, (List<TclCommand>)classBody.getCommands(), context);
        IElementRequestor.TypeInfo ti = new IElementRequestor.TypeInfo();
        ti.declarationStart = command.getStart();
        ti.nameSourceStart = className.getStart();
        ti.nameSourceEnd = className.getEnd() - 1;
        ti.modifiers = 0x400000;
        ti.superclasses = clazz.getSuperClasses();
        ITclTypeHandler resolvedType = ((ITclTypeResolver)context.get(ITclTypeResolver.class)).resolveType(ti, command.getEnd(), IncrTclClass.asSymbol((TclArgument)className));
        context.enterNamespace(resolvedType);
        clazz.setName(resolvedType.getNamespace());
        IncrTclNames.create(context).addType(clazz);
        for (IMember member : clazz.getMembers()) {
            if (member instanceof IMethod) {
                IMethod method = (IMethod)member;
                IElementRequestor.MethodInfo mi = new IElementRequestor.MethodInfo();
                mi.name = member.getName();
                mi.modifiers = method.getModifiers();
                mi.isConstructor = method.getKind() == IMethod.MethodKind.CONSTRUCTOR;
                mi.nameSourceStart = member.getNameStart();
                mi.nameSourceEnd = member.getNameEnd();
                mi.declarationStart = member.getStart();
                this.fillParameters(mi, method.getParameters());
                context.getRequestor().enterMethodRemoveSame(mi);
                for (TclArgument body : method.getBodies()) {
                    context.parse(body);
                }
                context.getRequestor().exitMethod(member.getEnd());
                continue;
            }
            if (!(member instanceof IVariable)) continue;
            IVariable variable = (IVariable)member;
            IElementRequestor.FieldInfo fi = new IElementRequestor.FieldInfo();
            fi.name = member.getName();
            fi.modifiers = variable.getModifiers();
            fi.nameSourceStart = variable.getNameStart();
            fi.nameSourceEnd = variable.getNameEnd();
            fi.declarationStart = variable.getStart();
            if (!context.getRequestor().enterFieldCheckDuplicates(fi)) continue;
            context.getRequestor().exitField(variable.getEnd());
        }
        context.leaveNamespace(resolvedType);
        return false;
    }

    private void processContent(IClass clazz, List<TclCommand> bodyCommands, ITclModelBuildContext context) {
        for (TclCommand cmd : bodyCommands) {
            this.processContent(clazz, new CommandImpl(cmd), context);
        }
    }

    private void processContent(IClass clazz, ICommand cmd, ITclModelBuildContext context) {
        Handler handler;
        TclArgument cmdName = cmd.getName();
        if (IncrTclClass.isSymbol((TclArgument)cmdName) && (handler = this.handlers.get(IncrTclClass.asSymbol((TclArgument)cmdName))) != null) {
            handler.handle(clazz, cmd, context);
        }
    }

    protected void handleInherit(IClass clazz, ICommand command) {
        if (command.getArgumentCount() == 0) {
            return;
        }
        TclArgument[] tclArgumentArray = command.getArguments();
        int n = tclArgumentArray.length;
        int n2 = 0;
        while (n2 < n) {
            TclArgument argument = tclArgumentArray[n2];
            if (IncrTclClass.isSymbol((TclArgument)argument)) {
                clazz.addSuperclass(IncrTclClass.asSymbol((TclArgument)argument));
            }
            ++n2;
        }
    }

    protected void handleVariable(IClass clazz, ICommand command, IVariable.VariableKind kind) {
        if (command.getArgumentCount() == 0) {
            return;
        }
        TclArgument varName = command.getArgument(0);
        if (IncrTclClass.isSymbol((TclArgument)varName)) {
            Variable variable = new Variable();
            variable.setRange(command);
            variable.setNameRange((Node)varName);
            variable.setName(IncrTclClass.asSymbol((TclArgument)varName));
            variable.setKind(kind);
            variable.setVisibility(clazz.peekVisibility());
            clazz.addMember(variable);
        }
    }

    protected void handleProc(IClass clazz, ICommand command, IMethod.MethodKind kind) {
        if (command.getArgumentCount() == 0) {
            return;
        }
        TclArgument procName = command.getArgument(0);
        if (IncrTclClass.isSymbol((TclArgument)procName)) {
            Method method = new Method();
            method.setRange(command);
            method.setNameRange((Node)procName);
            method.setName(IncrTclClass.asSymbol((TclArgument)procName));
            method.setKind(kind);
            method.setVisibility(clazz.peekVisibility());
            if (command.getArgumentCount() >= 2) {
                this.parseRawParameters(command.getArgument(1), method.getParameters());
            }
            if (command.getArgumentCount() == 3) {
                method.addBody(command.getArgument(2));
            }
            clazz.addMember(method);
        }
    }

    protected void handleDestructor(IClass clazz, ICommand command) {
        if (command.getArgumentCount() == 0) {
            return;
        }
        Method method = new Method();
        method.setRange(command);
        method.setNameRange((Node)command.getName());
        method.setName(IncrTclClass.asSymbol((TclArgument)command.getName()));
        method.setKind(IMethod.MethodKind.DESTRUCTOR);
        method.setVisibility(clazz.peekVisibility());
        if (command.getArgumentCount() == 1) {
            method.addBody(command.getArgument(0));
        }
        clazz.addMember(method);
    }

    protected void handleConstructor(IClass clazz, ICommand command) {
        if (command.getArgumentCount() < 2) {
            return;
        }
        Method method = new Method();
        method.setRange(command);
        method.setNameRange((Node)command.getName());
        method.setName(IncrTclClass.asSymbol((TclArgument)command.getName()));
        method.setKind(IMethod.MethodKind.CONSTRUCTOR);
        method.setVisibility(clazz.peekVisibility());
        this.parseRawParameters(command.getArgument(0), method.getParameters());
        method.addBody(command.getArgument(1));
        if (command.getArgumentCount() == 3) {
            method.addBody(command.getArgument(2));
        }
        clazz.addMember(method);
    }

    protected void handleVisibility(IClass clazz, ICommand command, ITclModelBuildContext context, IMember.Visibility visibility) {
        if (command.getArgumentCount() == 0) {
            return;
        }
        clazz.pushVisibility(visibility);
        if (command.getArgumentCount() == 1) {
            TclArgument bodyArg = command.getArgument(0);
            this.processContent(clazz, (List<TclCommand>)context.parse(bodyArg).getCommands(), context);
        } else {
            this.processContent(clazz, new PrefixedCommandImpl(command), context);
        }
        clazz.popVisibility();
    }

    private static interface Handler {
        public void handle(IClass var1, ICommand var2, ITclModelBuildContext var3);
    }
}

