/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.ui.text;

import org.eclipse.dltk.ui.text.util.AutoEditUtils;
import org.eclipse.dltk.ui.text.util.TabStyle;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.text.DefaultIndentLineAutoEditStrategy;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.TextUtilities;

public class ScriptDefaultIndentLineAutoEditStrategy
extends DefaultIndentLineAutoEditStrategy {
    protected final IPreferenceStore fPreferenceStore;

    public ScriptDefaultIndentLineAutoEditStrategy(IPreferenceStore fPreferenceStore) {
        this.fPreferenceStore = fPreferenceStore;
    }

    protected int getIndentSize() {
        return this.fPreferenceStore.getInt("formatter.indentation.size");
    }

    protected TabStyle getTabStyle() {
        return TabStyle.forName(this.fPreferenceStore.getString("formatter.tabulation.char"), TabStyle.TAB);
    }

    protected String getIndent() {
        if (this.getTabStyle() == TabStyle.SPACES) {
            return AutoEditUtils.getNSpaces(this.getIndentSize());
        }
        return "\t";
    }

    protected boolean isLineDelimiter(IDocument document, String text) {
        String[] delimiters = document.getLegalLineDelimiters();
        return delimiters != null && TextUtilities.equals((String[])delimiters, (String)text) > -1;
    }
}

