/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.compiler.env.lookup;

import org.eclipse.dltk.internal.compiler.lookup.LookupEnvironment;
import org.eclipse.dltk.internal.compiler.lookup.MethodScope;
import org.eclipse.dltk.internal.compiler.lookup.SourceModuleScope;
import org.eclipse.dltk.internal.compiler.lookup.TypeScope;

public abstract class Scope {
    public static final int BLOCK_SCOPE = 1;
    public static final int METHOD_SCOPE = 2;
    public static final int CLASS_SCOPE = 3;
    public static final int COMPILATION_UNIT_SCOPE = 4;
    public static final int NOT_COMPATIBLE = -1;
    public static final int COMPATIBLE = 0;
    public static final int AUTOBOX_COMPATIBLE = 1;
    public static final int VARARGS_COMPATIBLE = 2;
    public static final int EQUAL_OR_MORE_SPECIFIC = -1;
    public static final int NOT_RELATED = 0;
    public static final int MORE_GENERIC = 1;
    public int kind;
    public Scope parent;

    protected Scope(int kind, Scope parent) {
        this.kind = kind;
        this.parent = parent;
    }

    public final TypeScope classScope() {
        Scope scope = this;
        do {
            if (!(scope instanceof TypeScope)) continue;
            return (TypeScope)scope;
        } while ((scope = scope.parent) != null);
        return null;
    }

    public final SourceModuleScope sourceModuleScope() {
        Scope lastScope = null;
        Scope scope = this;
        do {
            lastScope = scope;
        } while ((scope = scope.parent) != null);
        return (SourceModuleScope)lastScope;
    }

    public final TypeScope enclosingClassScope() {
        Scope scope = this;
        while ((scope = scope.parent) != null) {
            if (!(scope instanceof TypeScope)) continue;
            return (TypeScope)scope;
        }
        return null;
    }

    public final MethodScope enclosingMethodScope() {
        Scope scope = this;
        while ((scope = scope.parent) != null) {
            if (!(scope instanceof MethodScope)) continue;
            return (MethodScope)scope;
        }
        return null;
    }

    public final LookupEnvironment environment() {
        Scope scope;
        Scope unitScope = this;
        while ((scope = unitScope.parent) != null) {
            unitScope = scope;
        }
        return ((SourceModuleScope)unitScope).environment;
    }

    public int startIndex() {
        return 0;
    }
}

