/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.internal.ui.model;

import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.mapping.ModelProvider;
import org.eclipse.core.resources.mapping.ResourceMapping;
import org.eclipse.core.resources.mapping.ResourceMappingContext;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.dltk.core.DLTKCore;
import org.eclipse.dltk.core.IModelElement;
import org.eclipse.dltk.internal.ui.model.DLTKElementResourceMapping;
import org.eclipse.dltk.internal.ui.model.DLTKResourceMapping;

public final class ScriptModelProvider
extends ModelProvider {
    public static final String DLTK_MODEL_PROVIDER_ID = "org.eclipse.dltk.ui.modelProvider";

    public static IResource getResource(Object element) {
        IResource resource = null;
        if (element instanceof IModelElement) {
            resource = ((IModelElement)element).getResource();
        } else if (element instanceof IResource) {
            resource = (IResource)element;
        } else if (element instanceof IAdaptable) {
            IAdaptable adaptable = (IAdaptable)element;
            IResource adapted = (IResource)adaptable.getAdapter(IResource.class);
            if (adapted != null) {
                resource = adapted;
            }
        } else {
            IResource adapted = (IResource)Platform.getAdapterManager().getAdapter(element, IResource.class);
            if (adapted != null) {
                resource = adapted;
            }
        }
        return resource;
    }

    public ResourceMapping[] getMappings(IResource resource, ResourceMappingContext context, IProgressMonitor monitor) throws CoreException {
        IModelElement element = DLTKCore.create((IResource)resource);
        if (element != null) {
            return new ResourceMapping[]{DLTKElementResourceMapping.create(element)};
        }
        ResourceMapping adapted = (ResourceMapping)resource.getAdapter(ResourceMapping.class);
        if (adapted != null) {
            return new ResourceMapping[]{adapted};
        }
        return new ResourceMapping[]{new DLTKResourceMapping(resource)};
    }
}

