/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.ui.internal.actions;

import java.util.Map;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.egit.ui.internal.UIText;
import org.eclipse.egit.ui.internal.actions.RepositoryActionHandler;
import org.eclipse.egit.ui.internal.fetch.FetchOperationUI;
import org.eclipse.egit.ui.internal.fetch.SimpleConfigureFetchDialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.transport.RemoteConfig;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.commands.IElementUpdater;
import org.eclipse.ui.menus.UIElement;

public class SimpleFetchActionHandler
extends RepositoryActionHandler
implements IElementUpdater {
    public Object execute(ExecutionEvent event) throws ExecutionException {
        Repository repository = this.getRepository(true, event);
        if (repository == null) {
            return null;
        }
        RemoteConfig config = SimpleConfigureFetchDialog.getConfiguredRemote(repository);
        if (config == null) {
            MessageDialog.openInformation((Shell)this.getShell(event), (String)UIText.SimpleFetchActionHandler_NothingToFetchDialogTitle, (String)UIText.SimpleFetchActionHandler_NothingToFetchDialogMessage);
            return null;
        }
        new FetchOperationUI(repository, config, false).start();
        return null;
    }

    @Override
    public boolean isEnabled() {
        Repository repository = this.getRepository();
        return repository != null && SimpleConfigureFetchDialog.getConfiguredRemoteCached(repository) != null;
    }

    public void updateElement(UIElement element, Map parameters) {
        RemoteConfig config = SimpleConfigureFetchDialog.getConfiguredRemoteCached(this.getRepository());
        if (config != null) {
            element.setText(SimpleConfigureFetchDialog.getSimpleFetchCommandLabel(config));
        }
    }
}

