/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2e.core.internal;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.NoSuchElementException;
import org.eclipse.core.internal.runtime.DevClassPathHelper;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.osgi.util.ManifestElement;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Bundles {
    private static final Logger log = LoggerFactory.getLogger(Bundles.class);

    private Bundles() {
    }

    public static List<String> getClasspathEntries(Bundle bundle) {
        log.info("getClasspathEntries(Bundle={})", (Object)bundle);
        LinkedHashSet<String> cp = new LinkedHashSet<String>();
        if (Bundles.inDevelopmentMode()) {
            Collections.addAll(cp, Bundles.getDevClassPath(bundle.getSymbolicName()));
        }
        cp.addAll(Bundles.parseBundleClasspath(bundle));
        ArrayList<String> entries = new ArrayList<String>();
        for (String cpe : cp) {
            String entry = Bundles.getClasspathEntryPath(bundle, cpe);
            if (entry == null) continue;
            log.info("\tEntry: {}", (Object)entry);
            entries.add(entry);
        }
        return entries;
    }

    private static List<String> parseBundleClasspath(Bundle bundle) {
        String header = (String)bundle.getHeaders().get("Bundle-ClassPath");
        try {
            ManifestElement[] cpEntries = ManifestElement.parseHeader((String)"Bundle-ClassPath", (String)header);
            if (cpEntries != null) {
                return Arrays.stream(cpEntries).map(ManifestElement::getValue).toList();
            }
        }
        catch (BundleException ex) {
            log.warn("Could not parse bundle classpath of {}", (Object)bundle, (Object)ex);
        }
        return List.of(".");
    }

    public static String getClasspathEntryPath(Bundle bundle, String cp) {
        File file;
        try {
            if (".".equals(cp)) {
                return ((File)FileLocator.getBundleFileLocation((Bundle)bundle).orElseThrow()).getCanonicalPath();
            }
            URL url = bundle.getEntry(cp);
            if (url != null) {
                String path = FileLocator.toFileURL((URL)url).getFile();
                return IPath.fromOSString((String)path).toOSString();
            }
        }
        catch (IOException | NoSuchElementException ex) {
            log.warn("Could not get entry {} for bundle {}", new Object[]{cp, bundle, ex});
        }
        if (Bundles.inDevelopmentMode() && (file = new File(cp)).exists() && file.isAbsolute()) {
            return file.getAbsolutePath();
        }
        log.debug("Bundle {} does not have entry {}", (Object)bundle, (Object)cp);
        return null;
    }

    private static String[] getDevClassPath(String bundleSymbolicName) {
        return DevClassPathHelper.getDevClassPath((String)bundleSymbolicName);
    }

    private static boolean inDevelopmentMode() {
        return DevClassPathHelper.inDevelopmentMode();
    }
}

