/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.context.ui;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.mylyn.context.core.ContextComputationStrategy;
import org.eclipse.mylyn.context.core.IInteractionContext;
import org.eclipse.mylyn.internal.context.ui.Messages;

public class CompoundContextComputationStrategy
extends ContextComputationStrategy {
    private List<ContextComputationStrategy> delegates;

    public List<Object> computeContext(IInteractionContext context, IAdaptable input, IProgressMonitor monitor) {
        if (this.delegates == null || this.delegates.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<Object> objects = new ArrayList<Object>();
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor);
        int workPerDelegate = 1000;
        progress.beginTask(Messages.CompoundContextComputationStrategy_Computing_Context_Task_Label, this.delegates.size() * workPerDelegate);
        try {
            for (ContextComputationStrategy delegate : this.delegates) {
                if (progress.isCanceled()) {
                    break;
                }
                objects.addAll(delegate.computeContext(context, input, (IProgressMonitor)progress.newChild(workPerDelegate)));
            }
        }
        finally {
            progress.done();
        }
        return objects;
    }

    public List<ContextComputationStrategy> getDelegates() {
        return this.delegates;
    }

    public void setDelegates(List<ContextComputationStrategy> delegates) {
        this.delegates = delegates;
    }
}

