/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.cdt.autotools.ui.editors;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.linuxtools.cdt.autotools.core.AutotoolsPlugin;
import org.eclipse.linuxtools.cdt.autotools.ui.editors.AutoconfEditor;
import org.eclipse.linuxtools.cdt.autotools.ui.editors.AutoconfEditorMessages;
import org.eclipse.linuxtools.cdt.autotools.ui.editors.parser.AutoconfMacroElement;
import org.eclipse.linuxtools.cdt.autotools.ui.editors.parser.IAutoconfMacroValidator;
import org.eclipse.linuxtools.cdt.autotools.ui.editors.parser.InvalidMacroException;
import org.eclipse.linuxtools.cdt.autotools.ui.editors.parser.ParseException;
import org.eclipse.linuxtools.internal.cdt.autotools.core.AutotoolsPropertyConstants;
import org.eclipse.linuxtools.internal.cdt.autotools.ui.text.hover.AutoconfPrototype;
import org.eclipse.linuxtools.internal.cdt.autotools.ui.text.hover.AutoconfTextHover;

public class AutoconfEditorMacroValidator
implements IAutoconfMacroValidator {
    public final String AUTOCONF_MACRO_ARGS_TOO_FEW = "AutoconfMacroArgsTooFew";
    public final String AUTOCONF_MACRO_ARGS_TOO_MANY = "AutoconfMacroArgsTooMany";
    private AutoconfEditor fEditor;

    public AutoconfEditorMacroValidator(AutoconfEditor autoconfEditor) {
        this.fEditor = autoconfEditor;
    }

    public void validateMacroCall(AutoconfMacroElement macro) throws ParseException, InvalidMacroException {
        AutoconfPrototype p = AutoconfTextHover.getPrototype(macro.getName(), this.fEditor);
        if (p != null) {
            boolean tooFew = false;
            boolean tooMany = false;
            boolean justRight = false;
            int parms = macro.getParameterCount();
            int numPrototypes = p.getNumPrototypes();
            int minParms = 0;
            int maxParms = 0;
            int i = 0;
            while (i < numPrototypes) {
                if (parms < p.getMinParms(i)) {
                    tooFew = true;
                    minParms = p.getMinParms(i);
                } else if (parms > p.getMaxParms(i)) {
                    tooMany = true;
                    maxParms = p.getMaxParms(i);
                } else {
                    justRight = true;
                    break;
                }
                ++i;
            }
            int length = macro.getEndOffset() - macro.getStartOffset();
            int start = macro.getStartOffset();
            int end = macro.getEndOffset();
            int lineNumber = 0;
            try {
                lineNumber = macro.getDocument().getLineOfOffset(start);
            }
            catch (BadLocationException badLocationException) {}
            if (!justRight) {
                if (tooFew) {
                    String formatString = AutoconfEditorMessages.getFormattedString("AutoconfMacroArgsTooFew", AutotoolsPlugin.getDefault().getPreferenceStore().getString("autoconf_version"), p.getName(), Integer.toString(minParms));
                    throw new ParseException(formatString, start, end, lineNumber, 0, length, 1);
                }
                if (tooMany) {
                    String formatString = AutoconfEditorMessages.getFormattedString("AutoconfMacroArgsTooMany", AutotoolsPlugin.getDefault().getPreferenceStore().getString("autoconf_version"), p.getName(), Integer.toString(maxParms));
                    throw new ParseException(formatString, start, end, lineNumber, 0, length, 1);
                }
            }
            IProject project = this.fEditor.getProject();
            String acDocVer = AutoconfTextHover.getDefaultAutoconfMacrosVer();
            try {
                String acVer = project.getPersistentProperty(AutotoolsPropertyConstants.AUTOCONF_VERSION);
                if (acVer != null) {
                    acDocVer = acVer;
                } else {
                    acVer = project.getPersistentProperty(AutotoolsPropertyConstants.AUTOCONF_VERSION_COMPAT);
                    if (acVer != null) {
                        acDocVer = acVer;
                    }
                }
            }
            catch (CoreException coreException) {}
            macro.validate(acDocVer);
        }
    }
}

