/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.cdt.autotools.core.wizards;

import org.eclipse.cdt.core.model.CoreModel;
import org.eclipse.cdt.core.settings.model.ICConfigurationDescription;
import org.eclipse.cdt.core.templateengine.TemplateCore;
import org.eclipse.cdt.core.templateengine.process.ProcessArgument;
import org.eclipse.cdt.core.templateengine.process.ProcessFailureException;
import org.eclipse.cdt.core.templateengine.process.ProcessRunner;
import org.eclipse.cdt.managedbuilder.core.BuildException;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceDescription;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.linuxtools.cdt.autotools.core.AutotoolsPlugin;
import org.eclipse.linuxtools.internal.cdt.autotools.core.configure.AutotoolsConfigurationManager;
import org.eclipse.linuxtools.internal.cdt.autotools.core.configure.IAConfiguration;

public class SetAutotoolsStringOptionValue
extends ProcessRunner {
    public void process(TemplateCore template, ProcessArgument[] args, String processId, IProgressMonitor monitor) throws ProcessFailureException {
        String projectName = args[0].getSimpleValue();
        IProject projectHandle = ResourcesPlugin.getWorkspace().getRoot().getProject(projectName);
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        IWorkspaceDescription workspaceDesc = workspace.getDescription();
        boolean autoBuilding = workspaceDesc.isAutoBuilding();
        workspaceDesc.setAutoBuilding(false);
        try {
            workspace.setDescription(workspaceDesc);
        }
        catch (CoreException coreException) {}
        ProcessArgument[][] resourcePathObjects = args[1].getComplexArrayValue();
        int i = 0;
        while (i < resourcePathObjects.length) {
            ProcessArgument[] resourcePathObject = resourcePathObjects[i];
            String id = resourcePathObject[0].getSimpleValue();
            String value = resourcePathObject[1].getSimpleValue();
            try {
                this.setOptionValue(projectHandle, id, value);
            }
            catch (BuildException e) {
                throw new ProcessFailureException(AutotoolsPlugin.getFormattedString("SetAutotoolsStringOptionValue.error", new String[]{e.getMessage()}), (Throwable)e);
            }
            ++i;
        }
        workspaceDesc.setAutoBuilding(autoBuilding);
        try {
            workspace.setDescription(workspaceDesc);
        }
        catch (CoreException coreException) {}
    }

    private void setOptionValue(IProject projectHandle, String id, String value) throws BuildException, ProcessFailureException {
        AutotoolsConfigurationManager.getInstance().syncConfigurations(projectHandle);
        ICConfigurationDescription[] cfgds = CoreModel.getDefault().getProjectDescription(projectHandle).getConfigurations();
        if (cfgds != null && cfgds.length >= 1) {
            IAConfiguration iaConfig = AutotoolsConfigurationManager.getInstance().getConfiguration(projectHandle, cfgds[0].getId());
            iaConfig.setOption(id, value);
        }
    }
}

