/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.cdt.autotools.ui.editors.automake;

import java.net.URI;
import org.eclipse.cdt.core.resources.FileStorage;
import org.eclipse.core.filesystem.URIUtil;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IStorage;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.linuxtools.cdt.autotools.ui.AutotoolsUIPlugin;
import org.eclipse.linuxtools.internal.cdt.autotools.ui.MakeUIMessages;
import org.eclipse.linuxtools.internal.cdt.autotools.ui.editors.automake.AutomakeEditorFactory;
import org.eclipse.linuxtools.internal.cdt.autotools.ui.editors.automake.ExternalEditorInput;
import org.eclipse.linuxtools.internal.cdt.autotools.ui.editors.automake.IDirective;
import org.eclipse.linuxtools.internal.cdt.autotools.ui.editors.automake.IMakefile;
import org.eclipse.linuxtools.internal.cdt.autotools.ui.editors.automake.IWorkingCopyManager;
import org.eclipse.linuxtools.internal.cdt.autotools.ui.editors.automake.MakefileEditor;
import org.eclipse.linuxtools.internal.cdt.autotools.ui.editors.automake.WordPartDetector;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.texteditor.IDocumentProvider;
import org.eclipse.ui.texteditor.ITextEditor;
import org.eclipse.ui.texteditor.TextEditorAction;

public class OpenDeclarationAction
extends TextEditorAction {
    public OpenDeclarationAction() {
        this(null);
    }

    public OpenDeclarationAction(ITextEditor editor) {
        super(MakeUIMessages.getResourceBundle(), "OpenDeclarationAction.", editor);
    }

    public void run() {
        ITextEditor editor = this.getTextEditor();
        if (editor == null) {
            return;
        }
        ISelectionProvider provider = editor.getSelectionProvider();
        if (provider == null) {
            return;
        }
        IDirective[] directives = null;
        IWorkingCopyManager fManager = AutomakeEditorFactory.getDefault().getWorkingCopyManager();
        IMakefile makefile = fManager.getWorkingCopy(editor.getEditorInput());
        if (makefile != null) {
            IDocumentProvider prov = editor.getDocumentProvider();
            IDocument doc = prov.getDocument((Object)editor.getEditorInput());
            try {
                ITextSelection textSelection = (ITextSelection)provider.getSelection();
                int offset = textSelection.getOffset();
                WordPartDetector wordPart = new WordPartDetector(doc, textSelection.getOffset());
                String name = wordPart.toString();
                if (WordPartDetector.inMacro(doc, offset)) {
                    directives = makefile.getMacroDefinitions(name);
                    if (directives.length == 0) {
                        directives = makefile.getBuiltinMacroDefinitions(name);
                    }
                } else {
                    directives = makefile.getTargetRules(name);
                }
                if (directives != null && directives.length > 0) {
                    OpenDeclarationAction.openInEditor(directives[0]);
                }
            }
            catch (Exception exception) {}
        }
    }

    private static IEditorPart openInEditor(IDirective directive) throws PartInitException {
        URI fileURI = directive.getMakefile().getFileURI();
        IPath path = URIUtil.toPath((URI)fileURI);
        IFile file = AutotoolsUIPlugin.getWorkspace().getRoot().getFileForLocation(path);
        if (file != null) {
            IWorkbenchPage p = AutotoolsUIPlugin.getActivePage();
            if (p != null) {
                IEditorPart editorPart = IDE.openEditor((IWorkbenchPage)p, (IFile)file, (boolean)true);
                if (editorPart instanceof MakefileEditor) {
                    ((MakefileEditor)editorPart).setSelection(directive, true);
                }
                return editorPart;
            }
        } else {
            FileStorage storage = new FileStorage(path);
            ExternalEditorInput input = new ExternalEditorInput((IStorage)storage);
            IWorkbenchPage p = AutotoolsUIPlugin.getActivePage();
            if (p != null) {
                String editorID = "org.eclipse.cdt.make.editor";
                IEditorPart editorPart = IDE.openEditor((IWorkbenchPage)p, (IEditorInput)input, (String)editorID, (boolean)true);
                if (editorPart instanceof MakefileEditor) {
                    ((MakefileEditor)editorPart).setSelection(directive, true);
                }
                return editorPart;
            }
        }
        return null;
    }
}

