/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.changelog.core;

import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import org.eclipse.compare.rangedifferencer.IRangeComparator;
import org.eclipse.core.resources.IEncodedStorage;
import org.eclipse.core.resources.IStorage;
import org.eclipse.core.runtime.CoreException;

public class LineComparator
implements IRangeComparator {
    private String[] fLines;

    public static LineComparator create(IStorage storage, String outputEncoding) throws CoreException, UnsupportedEncodingException {
        LineComparator lineComparator;
        BufferedInputStream is = new BufferedInputStream(storage.getContents());
        try {
            String encoding = LineComparator.getEncoding(storage, outputEncoding);
            lineComparator = new LineComparator(is, encoding);
        }
        catch (Throwable throwable) {
            try {
                ((InputStream)is).close();
            }
            catch (IOException iOException) {}
            throw throwable;
        }
        try {
            ((InputStream)is).close();
        }
        catch (IOException iOException) {}
        return lineComparator;
    }

    private static String getEncoding(IStorage storage, String outputEncoding) throws CoreException {
        IEncodedStorage es;
        String charset;
        if (storage instanceof IEncodedStorage && (charset = (es = (IEncodedStorage)storage).getCharset()) != null) {
            return charset;
        }
        return outputEncoding;
    }

    public LineComparator(InputStream is, String encoding) throws UnsupportedEncodingException {
        TrailingLineFeedDetector trailingLineFeedDetector = new TrailingLineFeedDetector(is);
        BufferedReader br = new BufferedReader(new InputStreamReader((InputStream)trailingLineFeedDetector, encoding));
        ArrayList<String> ar = new ArrayList<String>();
        try {
            String line;
            while ((line = br.readLine()) != null) {
                ar.add(line);
            }
        }
        catch (IOException iOException) {}
        try {
            is.close();
        }
        catch (IOException iOException) {}
        if (trailingLineFeedDetector.hadTrailingLineFeed()) {
            ar.add("");
        }
        this.fLines = ar.toArray(new String[ar.size()]);
    }

    String getLine(int ix) {
        return this.fLines[ix];
    }

    public int getRangeCount() {
        return this.fLines.length;
    }

    public boolean rangesEqual(int thisIndex, IRangeComparator other, int otherIndex) {
        String s1 = this.fLines[thisIndex];
        String s2 = ((LineComparator)other).fLines[otherIndex];
        return s1.equals(s2);
    }

    public boolean skipRangeComparison(int length, int maxLength, IRangeComparator other) {
        return false;
    }

    private static class TrailingLineFeedDetector
    extends FilterInputStream {
        boolean trailingLF = false;

        protected TrailingLineFeedDetector(InputStream in) {
            super(in);
        }

        public int read() throws IOException {
            int c = super.read();
            this.trailingLF = this.isLineFeed(c);
            return c;
        }

        public int read(byte[] buffer, int off, int len) throws IOException {
            int length = super.read(buffer, off, len);
            if (length != -1) {
                int index = off + length - 1;
                if (index >= buffer.length) {
                    index = buffer.length - 1;
                }
                this.trailingLF = this.isLineFeed(buffer[index]);
            }
            return length;
        }

        private boolean isLineFeed(int c) {
            return c != -1 && c == 10;
        }

        public boolean hadTrailingLineFeed() {
            return this.trailingLF;
        }
    }
}

