/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.lttng.jni;

import java.util.ArrayList;
import java.util.HashMap;
import org.eclipse.linuxtools.lttng.jni.JniMarkerField;
import org.eclipse.linuxtools.lttng.jni.Jni_C_Common;
import org.eclipse.linuxtools.lttng.jni.common.Jni_C_Pointer_And_Library_Id;
import org.eclipse.linuxtools.lttng.jni.exception.JniException;
import org.eclipse.linuxtools.lttng.jni.exception.JniMarkerException;

public abstract class JniMarker
extends Jni_C_Common {
    private Jni_C_Pointer_And_Library_Id thisMarkerPtr = new Jni_C_Pointer_And_Library_Id();
    private String name = "";
    private String formatOverview = "";
    private HashMap<String, JniMarkerField> markerFieldsHashMap = null;
    private ArrayList<JniMarkerField> markerFieldsArrayList = null;

    protected native String ltt_getName(int var1, long var2);

    protected native String ltt_getFormatOverview(int var1, long var2);

    protected native long ltt_getSize(int var1, long var2);

    protected native short ltt_getLargestAlign(int var1, long var2);

    protected native short ltt_getIntSize(int var1, long var2);

    protected native short ltt_getLongSize(int var1, long var2);

    protected native short ltt_getPointerSize(int var1, long var2);

    protected native short ltt_getSize_tSize(int var1, long var2);

    protected native void ltt_getAllMarkerFields(int var1, long var2);

    protected native short ltt_getAlignement(int var1, long var2);

    protected native long ltt_getNextMarkerPtr(int var1, long var2);

    protected native void ltt_printMarker(int var1, long var2);

    protected JniMarker() {
    }

    public JniMarker(JniMarker oldMarker) {
        this.thisMarkerPtr = oldMarker.thisMarkerPtr;
        this.name = oldMarker.name;
        this.formatOverview = oldMarker.formatOverview;
        this.markerFieldsHashMap = oldMarker.markerFieldsHashMap;
        this.markerFieldsArrayList = oldMarker.markerFieldsArrayList;
    }

    public JniMarker(Jni_C_Pointer_And_Library_Id newMarkerPtr) throws JniException {
        this.thisMarkerPtr = newMarkerPtr;
        this.markerFieldsArrayList = new ArrayList();
        this.markerFieldsHashMap = new HashMap();
        this.populateMarkerInformation();
    }

    private void populateMarkerInformation() throws JniException {
        if (this.thisMarkerPtr.getPointer() == 0L) {
            throw new JniMarkerException("Pointer is NULL, trace closed? (populateMarkerInformatOverviewion)");
        }
        this.name = this.ltt_getName(this.thisMarkerPtr.getLibraryId(), this.thisMarkerPtr.getPointer());
        this.formatOverview = this.ltt_getFormatOverview(this.thisMarkerPtr.getLibraryId(), this.thisMarkerPtr.getPointer());
        this.ltt_getAllMarkerFields(this.thisMarkerPtr.getLibraryId(), this.thisMarkerPtr.getPointer());
    }

    private void addMarkerFieldFromC(String markerFieldName, long markerFieldPtr) {
        try {
            JniMarkerField newMarkerField = this.allocateNewJniMarkerField(new Jni_C_Pointer_And_Library_Id(this.thisMarkerPtr.getLibraryId(), markerFieldPtr));
            this.markerFieldsArrayList.add(newMarkerField);
            this.markerFieldsHashMap.put(markerFieldName, newMarkerField);
        }
        catch (JniException e) {
            this.printlnC(this.thisMarkerPtr.getLibraryId(), "Failed to add marker field " + markerFieldName + " to marker fields list!(addMarkerFieldFromC)\n\tException raised : " + e.toString());
        }
    }

    public String getName() {
        return this.name;
    }

    public String getFormatOverview() {
        return this.formatOverview;
    }

    public HashMap<String, JniMarkerField> getMarkerFieldsHashMap() {
        return this.markerFieldsHashMap;
    }

    public ArrayList<JniMarkerField> getMarkerFieldsArrayList() {
        return this.markerFieldsArrayList;
    }

    public Jni_C_Pointer_And_Library_Id getMarkerPtr() {
        return this.thisMarkerPtr;
    }

    public void printMarkerInformation() {
        this.ltt_printMarker(this.thisMarkerPtr.getLibraryId(), this.thisMarkerPtr.getPointer());
    }

    public void printAllMarkerFieldsInformation() {
        Object[] allMarkersField = this.markerFieldsArrayList.toArray();
        int pos = 0;
        while (pos < allMarkersField.length) {
            this.printlnC(this.thisMarkerPtr.getLibraryId(), allMarkersField[pos].toString());
            ++pos;
        }
    }

    public String toString() {
        String returnData = "";
        returnData = String.valueOf(returnData) + "name                    : " + this.name + "\n";
        returnData = String.valueOf(returnData) + "formatOverview          : " + this.formatOverview + "\n";
        returnData = String.valueOf(returnData) + "markerFieldArrayList    : " + this.markerFieldsArrayList.hashCode() + " (size : " + this.markerFieldsArrayList.size() + " )" + "\n";
        return returnData;
    }

    public abstract JniMarkerField allocateNewJniMarkerField(Jni_C_Pointer_And_Library_Id var1) throws JniException;
}

