/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.lttng.ui.tracecontrol.actions;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.linuxtools.lttng.core.tracecontrol.model.TraceResource;
import org.eclipse.linuxtools.lttng.core.tracecontrol.model.config.TraceConfig;
import org.eclipse.linuxtools.lttng.core.tracecontrol.service.ILttControllerService;
import org.eclipse.linuxtools.lttng.core.tracecontrol.service.LttControllerServiceProxy;
import org.eclipse.linuxtools.lttng.core.tracecontrol.utility.LiveTraceManager;
import org.eclipse.linuxtools.lttng.ui.LTTngUiPlugin;
import org.eclipse.linuxtools.lttng.ui.tracecontrol.Messages;
import org.eclipse.linuxtools.lttng.ui.tracecontrol.actions.ImportToProject;
import org.eclipse.linuxtools.lttng.ui.tracecontrol.dialogs.SelectTracePathDialog;
import org.eclipse.linuxtools.lttng.ui.tracecontrol.subsystems.TraceSubSystem;
import org.eclipse.rse.core.model.ISystemRegistry;
import org.eclipse.rse.core.model.SystemStartHere;
import org.eclipse.rse.core.subsystems.ISubSystem;
import org.eclipse.rse.services.clientserver.messages.SystemMessageException;
import org.eclipse.rse.ui.SystemBasePlugin;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.tm.tcf.protocol.IToken;
import org.eclipse.tm.tcf.util.TCFTask;
import org.eclipse.ui.IObjectActionDelegate;
import org.eclipse.ui.IViewActionDelegate;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.IWorkbenchWindowActionDelegate;

public class StartTrace
implements IObjectActionDelegate,
IWorkbenchWindowActionDelegate,
IViewActionDelegate {
    private List<TraceResource> fSelectedTraces = new ArrayList<TraceResource>();

    public void setActivePart(IAction arg0, IWorkbenchPart arg1) {
    }

    public void run(IAction arg0) {
        int i = 0;
        while (i < this.fSelectedTraces.size()) {
            block9: {
                TraceResource trace = this.fSelectedTraces.get(i);
                TraceSubSystem subSystem = (TraceSubSystem)trace.getSubSystem();
                TraceConfig traceConfig = trace.getTraceConfig();
                if (traceConfig != null) {
                    try {
                        LttControllerServiceProxy service = subSystem.getControllerService();
                        if (trace.getTraceState() == TraceResource.TraceState.CONFIGURED) {
                            this.setTraceTransport((ILttControllerService)service, trace, traceConfig);
                            this.allocTrace((ILttControllerService)service, trace, traceConfig);
                            this.setupLocation((ILttControllerService)service, trace, traceConfig);
                        } else if (traceConfig.isNetworkTrace() && "network".equals(traceConfig.getTracePath())) {
                            SelectTracePathDialog selectDialog = new SelectTracePathDialog(SystemBasePlugin.getActiveWorkbenchShell());
                            if (selectDialog.open() != 0) break block9;
                            traceConfig.setTracePath(selectDialog.getTracePath());
                        }
                        this.startTrace((ILttControllerService)service, trace, traceConfig);
                        trace.setTraceState(TraceResource.TraceState.STARTED);
                        if (trace.isNetworkTraceAndStarted()) {
                            LiveTraceManager.setLiveTrace((String)trace.getTraceConfig().getTracePath(), (boolean)true);
                        }
                        ISystemRegistry registry = SystemStartHere.getSystemRegistry();
                        registry.fireRemoteResourceChangeEvent(4, (Object)trace, (Object)trace.getParent(), (ISubSystem)subSystem, null);
                    }
                    catch (Exception e) {
                        SystemMessageException sysExp = e instanceof SystemMessageException ? (SystemMessageException)((Object)e) : new SystemMessageException(LTTngUiPlugin.getDefault().getMessage(e));
                        SystemBasePlugin.logError((String)(String.valueOf(Messages.Lttng_Control_ErrorStart) + " (" + Messages.Lttng_Resource_Trace + ": " + trace.getName() + ")"), (Throwable)sysExp);
                    }
                }
            }
            ++i;
        }
    }

    public void selectionChanged(IAction action, ISelection selection) {
        if (selection instanceof IStructuredSelection) {
            this.fSelectedTraces.clear();
            for (Object obj : (IStructuredSelection)selection) {
                if (!(obj instanceof TraceResource)) continue;
                this.fSelectedTraces.add((TraceResource)obj);
            }
        }
    }

    protected Shell getShell() {
        return SystemBasePlugin.getActiveWorkbenchShell();
    }

    public void init(IWorkbenchWindow arg0) {
    }

    public void dispose() {
    }

    public void init(IViewPart view) {
    }

    private void setTraceTransport(final ILttControllerService service, final TraceResource trace, final TraceConfig oldConfig) throws Exception {
        new TCFTask<Boolean>(){

            public void run() {
                service.setTraceTransport(trace.getParent().getParent().getName(), trace.getParent().getName(), oldConfig.getTraceName(), oldConfig.getTraceTransport(), new ILttControllerService.DoneSetTraceTransport(){

                    public void doneSetTraceTransport(IToken token, Exception error, Object str) {
                        if (error != null) {
                            this.error(error);
                            return;
                        }
                        this.done(true);
                    }
                });
            }
        }.get(10L, TimeUnit.SECONDS);
    }

    private void allocTrace(final ILttControllerService service, final TraceResource trace, TraceConfig oldConfig) throws Exception {
        new TCFTask<Boolean>(){

            public void run() {
                service.allocTrace(trace.getParent().getParent().getName(), trace.getParent().getName(), trace.getName(), new ILttControllerService.DoneAllocTrace(){

                    public void doneAllocTrace(IToken token, Exception error, Object str) {
                        if (error != null) {
                            this.error(error);
                            return;
                        }
                        this.done(true);
                    }
                });
            }
        }.get(10L, TimeUnit.SECONDS);
    }

    private void setupLocation(final ILttControllerService service, final TraceResource trace, final TraceConfig traceConfig) throws Exception {
        if (traceConfig.isNetworkTrace()) {
            boolean created;
            File newDir = new File(traceConfig.getTracePath());
            if (!newDir.exists() && !(created = newDir.mkdirs())) {
                throw new Exception(String.valueOf(Messages.Lttng_Control_ErrorCreateTracePath) + ": " + traceConfig.getTracePath());
            }
            if (traceConfig.getProject() != null) {
                ImportToProject.linkTrace(this.getShell(), trace, traceConfig.getProject(), traceConfig.getTraceName());
            }
            new TCFTask<Boolean>(){

                public void run() {
                    service.writeTraceNetwork(trace.getParent().getParent().getName(), trace.getParent().getName(), traceConfig.getTraceName(), traceConfig.getTracePath(), traceConfig.getNumChannel(), Boolean.valueOf(traceConfig.getIsAppend()), Boolean.valueOf(false), Boolean.valueOf(true), new ILttControllerService.DoneWriteTraceNetwork(){

                        public void doneWriteTraceNetwork(IToken token, Exception error, Object str) {
                            if (error != null) {
                                this.error(error);
                                return;
                            }
                            this.done(true);
                        }
                    });
                }
            }.get(10L, TimeUnit.SECONDS);
        } else {
            new TCFTask<Boolean>(){

                public void run() {
                    service.writeTraceLocal(trace.getParent().getParent().getName(), trace.getParent().getName(), traceConfig.getTraceName(), traceConfig.getTracePath(), traceConfig.getNumChannel(), Boolean.valueOf(traceConfig.getIsAppend()), Boolean.valueOf(false), Boolean.valueOf(true), new ILttControllerService.DoneWriteTraceLocal(){

                        public void doneWriteTraceLocal(IToken token, Exception error, Object str) {
                            if (error != null) {
                                this.error(error);
                                return;
                            }
                            this.done(true);
                        }
                    });
                }
            }.get(10L, TimeUnit.SECONDS);
        }
    }

    private void startTrace(final ILttControllerService service, final TraceResource trace, final TraceConfig oldConfig) throws Exception {
        new TCFTask<Boolean>(){

            public void run() {
                service.startTrace(trace.getParent().getParent().getName(), trace.getParent().getName(), oldConfig.getTraceName(), new ILttControllerService.DoneStartTrace(){

                    public void doneStartTrace(IToken token, Exception error, Object str) {
                        if (error != null) {
                            this.error(error);
                            return;
                        }
                        this.done(true);
                    }
                });
            }
        }.get(10L, TimeUnit.SECONDS);
    }
}

