/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.lttng.ui.views.latency.listeners;

import org.eclipse.linuxtools.lttng.ui.views.latency.AbstractViewer;
import org.eclipse.linuxtools.lttng.ui.views.latency.Messages;
import org.eclipse.linuxtools.lttng.ui.views.latency.listeners.AbstractMouseTrackListener;
import org.eclipse.linuxtools.lttng.ui.views.latency.listeners.HistogramPaintListener;

public class TooltipListener
extends AbstractMouseTrackListener {
    protected AbstractViewer fView;
    protected HistogramPaintListener fHistogram;
    protected boolean fDisplayWarning = false;

    public TooltipListener(AbstractViewer view, HistogramPaintListener histogramPaintListener) {
        this.fView = view;
        this.fHistogram = histogramPaintListener;
    }

    @Override
    protected void display() {
        this.displayWarningTooltip();
        this.displayTooltip();
    }

    protected void displayWarningTooltip() {
        if (this.fHistogram.barIsClipped() && this.fMouseX > 5 && this.fMouseX < 21 && this.fMouseY > 3 && this.fMouseY < 18) {
            this.fView.setToolTipText(Messages.LatencyView_ClippingWarning);
            this.fDisplayWarning = true;
        } else {
            this.fDisplayWarning = false;
        }
    }

    protected void displayTooltip() {
        if (!this.fDisplayWarning) {
            this.fView.setToolTipText(this.fHistogram.formatToolTipLabel(this.fMouseX, this.fMouseY));
        }
    }
}

