/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.tmf.ui.views.colors;

import org.eclipse.linuxtools.tmf.core.filter.model.ITmfFilterTreeNode;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.themes.ColorUtil;

public class ColorSetting {
    private RGB fForegroundRGB;
    private RGB fBackgroundRGB;
    private Color fForegroundColor;
    private Color fBackgroundColor;
    private Color fDimmedForegroundColor;
    private Color fDimmedBackgroundColor;
    private int fTickColorIndex;
    private ITmfFilterTreeNode fFilter;

    public ColorSetting(RGB foreground, RGB background, int tickColorIndex, ITmfFilterTreeNode filter) {
        this.fForegroundRGB = foreground;
        this.fBackgroundRGB = background;
        this.fTickColorIndex = tickColorIndex;
        this.fFilter = filter;
        Display display = Display.getDefault();
        this.fForegroundColor = new Color((Device)display, this.fForegroundRGB);
        this.fBackgroundColor = new Color((Device)display, this.fBackgroundRGB);
        this.fDimmedForegroundColor = new Color((Device)display, ColorUtil.blend((RGB)this.fForegroundRGB, (RGB)this.fBackgroundRGB));
        this.fDimmedBackgroundColor = new Color((Device)display, ColorUtil.blend((RGB)this.fBackgroundRGB, (RGB)display.getSystemColor(25).getRGB()));
    }

    public void dispose() {
        this.fForegroundColor.dispose();
        this.fBackgroundColor.dispose();
        this.fDimmedForegroundColor.dispose();
        this.fDimmedBackgroundColor.dispose();
    }

    public RGB getForegroundRGB() {
        return this.fForegroundRGB;
    }

    public void setForegroundRGB(RGB foreground) {
        this.fForegroundRGB = foreground;
        this.fForegroundColor.dispose();
        this.fDimmedForegroundColor.dispose();
        Display display = Display.getDefault();
        this.fForegroundColor = new Color((Device)display, this.fForegroundRGB);
        this.fDimmedForegroundColor = new Color((Device)display, ColorUtil.blend((RGB)this.fForegroundRGB, (RGB)this.fBackgroundRGB));
    }

    public RGB getBackgroundRGB() {
        return this.fBackgroundRGB;
    }

    public void setBackgroundRGB(RGB background) {
        this.fBackgroundRGB = background;
        this.fBackgroundColor.dispose();
        this.fDimmedBackgroundColor.dispose();
        Display display = Display.getDefault();
        this.fBackgroundColor = new Color((Device)display, this.fBackgroundRGB);
        this.fDimmedBackgroundColor = new Color((Device)display, ColorUtil.blend((RGB)this.fBackgroundRGB, (RGB)display.getSystemColor(25).getRGB()));
    }

    public int getTickColorIndex() {
        return this.fTickColorIndex;
    }

    public void setTickColorIndex(int tickColorIndex) {
        this.fTickColorIndex = tickColorIndex;
    }

    public ITmfFilterTreeNode getFilter() {
        return this.fFilter;
    }

    public void setFilter(ITmfFilterTreeNode filter) {
        this.fFilter = filter;
    }

    public Color getForegroundColor() {
        return this.fForegroundColor;
    }

    public Color getBackgroundColor() {
        return this.fBackgroundColor;
    }

    public Color getDimmedForegroundColor() {
        return this.fDimmedForegroundColor;
    }

    public Color getDimmedBackgroundColor() {
        return this.fDimmedBackgroundColor;
    }
}

