/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.gprof.symbolManager;

import org.eclipse.cdt.core.IAddress;
import org.eclipse.cdt.core.IBinaryParser;
import org.eclipse.core.resources.IProject;
import org.eclipse.linuxtools.binutils.utils.STSymbolManager;
import org.eclipse.linuxtools.internal.gprof.symbolManager.CallGraphNode;

public class CallGraphArc {
    public final CallGraphNode parent;
    public final CallGraphNode child;
    private int count;
    private IProject project;
    public String parentPath;
    public int parentLine;

    public CallGraphArc(CallGraphNode parent, IAddress parentAddress, CallGraphNode child, int count, IBinaryParser.IBinaryObject program, IProject project) {
        this.parent = parent;
        this.child = child;
        this.count = count;
        this.parentPath = STSymbolManager.sharedInstance.getFileName(program, parentAddress, project);
        this.parentLine = STSymbolManager.sharedInstance.getLineNumber(program, parentAddress, project);
        this.project = project;
    }

    public int getCount() {
        return this.count;
    }

    public void setCount(int count) {
        this.count = count;
    }

    public void print() {
        System.out.print("    ");
        System.out.print(this.parent.getSymbol().getName());
        System.out.print(" -> ");
        System.out.print(this.child.getSymbol().getName());
        System.out.print(" :: ");
        System.out.println(this.count);
    }

    public IProject getProject() {
        return this.project;
    }
}

