/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.lttng.ui.views.latency.listeners;

import java.text.DecimalFormat;
import org.eclipse.linuxtools.lttng.ui.views.latency.AbstractViewer;
import org.eclipse.linuxtools.lttng.ui.views.latency.GraphViewer;
import org.eclipse.linuxtools.lttng.ui.views.latency.listeners.AbstractPaintListener;
import org.eclipse.linuxtools.lttng.ui.views.latency.model.GraphScaledData;
import org.eclipse.linuxtools.lttng.ui.views.latency.model.IGraphDataModel;
import org.eclipse.linuxtools.tmf.ui.views.histogram.HistogramUtils;

public class GraphPaintListener
extends AbstractPaintListener {
    protected GraphScaledData fScaledData;

    public GraphPaintListener(AbstractViewer view) {
        super(view);
    }

    @Override
    public void scale() {
        double width = this.getWidth();
        double height = this.getHeight();
        IGraphDataModel model = ((GraphViewer)this.fViewer).getModel();
        this.fScaledData = model.scaleTo((int)width, (int)height, this.fBarWith);
        this.fXMin = this.fScaledData.getHorFirstBucketTime() > 0L ? this.fScaledData.getHorFirstBucketTime() : 0L;
        this.fXMax = 0L;
        if (this.fScaledData.getHorLastBucket() > 0) {
            this.fXMax = this.fScaledData.getHorBucketEndTime(this.fScaledData.getHorNbBuckets() - 1);
        }
        this.fYMin = this.fScaledData.getVerFirstBucketTime() > 0L ? this.fScaledData.getVerFirstBucketTime() : 0L;
        this.fYMax = 0L;
        if (this.fScaledData.getVerLastBucket() > 0) {
            this.fYMax = this.fScaledData.getVerBucketEndTime(this.fScaledData.getVerNbBuckets() - 1);
        }
    }

    @Override
    public void paintContent() {
        if (this.fXMin >= 0L && this.fXMax >= 0L && this.fYMin >= 0L && this.fYMax >= 0L && this.fScaledData != null) {
            this.fAxisImage.setForeground(this.fDataColor);
            this.fAxisImage.setBackground(this.fDataColor);
            double height = this.getHeight();
            int xLen = this.fScaledData.getHorNbBuckets();
            int yLen = this.fScaledData.getVerNbBuckets();
            int barWidth = this.fScaledData.getBarWidth();
            int i = 0;
            while (i < xLen) {
                int j = 0;
                while (j < yLen) {
                    if (this.fScaledData.getEventCount(i, j) > 0) {
                        int xBarWidth;
                        double x = this.fPadding + i * barWidth + this.fVerticalAxisOffset + 1;
                        double y = (double)(this.fPadding + this.fPaddingTop) + height - (double)(j * barWidth);
                        int yBarWidth = this.fBarWith;
                        if (y - (double)yBarWidth < (double)(this.fPadding + this.fPaddingTop)) {
                            yBarWidth = (int)(y - (double)this.fPadding - (double)this.fPaddingTop);
                        }
                        if (x + (double)(xBarWidth = this.fBarWith) > (double)(this.fClientArea.width - this.fPadding - this.fPaddingRight)) {
                            xBarWidth = (int)((double)(this.fClientArea.width - this.fPadding - this.fPaddingRight) - x);
                        }
                        this.fAxisImage.fillRectangle((int)x, (int)y - yBarWidth, xBarWidth, yBarWidth);
                    }
                    ++j;
                }
                ++i;
            }
            if (this.fScaledData.isCurrentEventTimeValid()) {
                int index = this.fScaledData.getHorBucketIndex(this.fScaledData.getCurrentEventTime());
                int x = this.fPadding + index * barWidth + this.fVerticalAxisOffset + 1;
                this.fAxisImage.setForeground(this.fCurrentEventColor);
                this.fAxisImage.setBackground(this.fCurrentEventColor);
                this.fAxisImage.drawLine(x, this.fPadding + this.fPaddingTop, x, this.fClientArea.height - this.fPadding - this.fHorizontalAxisYOffset);
            }
        }
    }

    @Override
    public String formatStringForVerticalAxis(long value) {
        DecimalFormat formatter = new DecimalFormat("0.0E0");
        return formatter.format(value);
    }

    @Override
    public String formatStringForHorizontalAxis(long value) {
        return HistogramUtils.nanosecondsToString((long)value);
    }

    @Override
    public String formatToolTipLabel(int x, int y) {
        int index = this.getIndexFromHorizontalValue(x);
        int yIndex = this.getIndexFromVerticalValue(y);
        if (index != -1 && yIndex != -1 && this.fScaledData.getEventCount(index, yIndex) > 0) {
            StringBuffer buffer = new StringBuffer();
            buffer.append("Time Range in s = [");
            long startTime = this.fScaledData.getHorBucketStartTime(index) > 0L ? this.fScaledData.getHorBucketStartTime(index) : 0L;
            buffer.append(HistogramUtils.nanosecondsToString((long)startTime));
            buffer.append(",");
            buffer.append(HistogramUtils.nanosecondsToString((long)this.fScaledData.getHorBucketEndTime(index)));
            buffer.append("]\n");
            buffer.append("Latency Range in s = [");
            long yStartTime = this.fScaledData.getVerBucketStartTime(yIndex) > 0L ? this.fScaledData.getVerBucketStartTime(yIndex) : 0L;
            buffer.append(HistogramUtils.nanosecondsToString((long)yStartTime));
            buffer.append(",");
            buffer.append(HistogramUtils.nanosecondsToString((long)this.fScaledData.getVerBucketEndTime(yIndex)));
            buffer.append("]\n");
            buffer.append("Latency count = ");
            buffer.append(this.fScaledData.getEventCount(index, yIndex));
            return buffer.toString();
        }
        return "";
    }

    public int getIndexFromHorizontalValue(int x) {
        double barWidth;
        int index;
        if (this.fScaledData != null && (index = (int)((double)(x - this.fPadding - this.fVerticalAxisOffset - 1) / (barWidth = (double)this.fScaledData.getBarWidth()))) >= 0 && this.fScaledData.getHorNbBuckets() > index) {
            return index;
        }
        return -1;
    }

    public int getIndexFromVerticalValue(int y) {
        if (this.fScaledData != null) {
            double barWidth = this.fScaledData.getBarWidth();
            double height = this.getHeight();
            int index = (int)((height - (double)(y - this.fPadding - this.fPaddingTop)) / barWidth);
            if (index >= 0 && this.fScaledData.getVerNbBuckets() > index) {
                return index;
            }
        }
        return -1;
    }

    public long getCurrentTimeFromHorizontalValue(int x) {
        int index;
        if (this.fXMin >= 0L && this.fXMax >= 0L && (index = this.getIndexFromHorizontalValue(x)) != -1) {
            return this.fScaledData.getHorBucketStartTime(index);
        }
        return -1L;
    }
}

