/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.tmf.core.experiment;

import java.util.Arrays;
import org.eclipse.linuxtools.tmf.core.experiment.TmfLocationArray;
import org.eclipse.linuxtools.tmf.core.trace.TmfLocation;

public class TmfExperimentLocation
extends TmfLocation<TmfLocationArray> {
    private long[] fRanks;

    public TmfExperimentLocation(TmfLocationArray locations, long[] ranks) {
        super(locations);
        this.fRanks = ranks;
    }

    @Override
    public TmfExperimentLocation clone() {
        super.clone();
        TmfLocationArray array = (TmfLocationArray)this.getLocation();
        TmfLocationArray clones = array.clone();
        return new TmfExperimentLocation(clones, (long[])this.fRanks.clone());
    }

    @Override
    public String toString() {
        StringBuilder result = new StringBuilder("[TmfExperimentLocation");
        TmfLocationArray array = (TmfLocationArray)this.getLocation();
        int i = 0;
        while (i < array.locations.length) {
            result.append("[" + array.locations[i].toString() + "," + this.fRanks[i] + "]");
            ++i;
        }
        result.append("]");
        return result.toString();
    }

    public long[] getRanks() {
        return this.fRanks;
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + Arrays.hashCode(this.fRanks);
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        TmfExperimentLocation other = (TmfExperimentLocation)obj;
        return Arrays.equals(this.fRanks, other.fRanks);
    }
}

