/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.rpmstubby.model;

import java.util.ArrayList;
import java.util.List;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PomModel {
    private Document docroot;
    private XPath xpath;

    public PomModel(Document docroot) {
        this.docroot = docroot;
        this.xpath = XPathFactory.newInstance().newXPath();
    }

    public String getPackageName() {
        return this.xpathEval("/project/artifactId");
    }

    public String getArtifactId() {
        return this.xpathEval("/project/artifactId");
    }

    public String getGroupId() {
        String groupId = this.xpathEval("/project/groupId");
        if (groupId.equals("")) {
            groupId = this.xpathEval("/project/parent/groupId");
        }
        return groupId;
    }

    public String getSummary() {
        return this.xpathEval("/project/name");
    }

    public String getVersion() {
        String version = this.xpathEval("/project/version");
        if (version.equals("")) {
            version = this.xpathEval("/project/parent/version");
        }
        return version;
    }

    public String getLicense() {
        return this.xpathEval("/project/licenses/license/name");
    }

    public String getURL() {
        String url = this.xpathEval("/project/url");
        if (url.equals("")) {
            url = this.xpathEval("/project/organization/url");
        }
        return url;
    }

    public String getDescription() {
        this.getDependencies();
        return this.xpathEval("/project/description");
    }

    public List<String> getDependencies() {
        ArrayList<String> dependencies = new ArrayList<String>();
        NodeList nodes = this.xpathEvalNodes("/project/dependencies/dependency/artifactId");
        int i = 0;
        while (i < nodes.getLength()) {
            Node node = nodes.item(i);
            dependencies.add(node.getTextContent());
            ++i;
        }
        return dependencies;
    }

    private String xpathEval(String path) {
        String result = "";
        try {
            result = this.xpath.evaluate(path, this.docroot);
        }
        catch (XPathExpressionException e) {
            e.printStackTrace();
        }
        return result;
    }

    private NodeList xpathEvalNodes(String path) {
        NodeList result = null;
        try {
            result = (NodeList)this.xpath.evaluate(path, this.docroot, XPathConstants.NODESET);
        }
        catch (XPathExpressionException e) {
            e.printStackTrace();
        }
        return result;
    }
}

