/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.tmf.event;

import java.util.HashMap;
import org.eclipse.linuxtools.tmf.event.TmfNoSuchFieldException;

public class TmfEventType
implements Cloneable {
    public static final String DEFAULT_TYPE_ID = "TMF Default Type";
    public static final String[] DEFAULT_LABELS = new String[]{"Content"};
    private String fTypeId;
    private String[] fFieldLabels;
    private int fNbFields;
    private HashMap<String, Integer> fFieldMap;

    public TmfEventType() {
        this(DEFAULT_TYPE_ID, DEFAULT_LABELS);
    }

    public TmfEventType(String typeId, String[] labels) {
        if (typeId == null || labels == null) {
            throw new IllegalArgumentException();
        }
        this.fTypeId = typeId;
        this.fFieldLabels = labels;
        this.fNbFields = this.fFieldLabels.length;
        this.fFieldMap = new HashMap();
        int i = 0;
        while (i < this.fNbFields) {
            this.fFieldMap.put(this.fFieldLabels[i], i);
            ++i;
        }
    }

    public TmfEventType(TmfEventType other) {
        if (other == null) {
            throw new IllegalArgumentException();
        }
        this.fTypeId = other.fTypeId;
        this.fFieldLabels = other.fFieldLabels;
        this.fNbFields = other.fNbFields;
        this.fFieldMap = other.fFieldMap;
    }

    public String getTypeId() {
        return this.fTypeId;
    }

    public int getNbFields() {
        return this.fNbFields;
    }

    public int getFieldIndex(String id) throws TmfNoSuchFieldException {
        Integer index = this.fFieldMap.get(id);
        if (index == null) {
            throw new TmfNoSuchFieldException(id);
        }
        return index;
    }

    public String[] getLabels() {
        return this.fFieldLabels;
    }

    public String getLabel(int i) throws TmfNoSuchFieldException {
        if (i >= 0 && i < this.fNbFields) {
            return this.fFieldLabels[i];
        }
        throw new TmfNoSuchFieldException("Bad index (" + i + ")");
    }

    public int hashCode() {
        return this.fTypeId.hashCode();
    }

    public boolean equals(Object other) {
        if (!(other instanceof TmfEventType)) {
            return false;
        }
        TmfEventType o = (TmfEventType)other;
        return this.fTypeId.equals(o.fTypeId);
    }

    public String toString() {
        return "[TmfEventType:" + this.fTypeId + "]";
    }

    public TmfEventType clone() {
        TmfEventType clone = null;
        try {
            clone = (TmfEventType)super.clone();
            clone.fTypeId = new String(this.fTypeId);
            clone.fNbFields = this.fNbFields;
            clone.fFieldLabels = new String[this.fFieldLabels.length];
            int i = 0;
            while (i < this.fFieldLabels.length) {
                clone.fFieldLabels[i] = new String(this.fFieldLabels[i]);
                ++i;
            }
            clone.fFieldMap = new HashMap();
            for (String key : this.fFieldMap.keySet()) {
                clone.fFieldMap.put(new String(key), new Integer(this.fFieldMap.get(key)));
            }
        }
        catch (CloneNotSupportedException e) {
            e.printStackTrace();
        }
        return clone;
    }
}

