/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.tmf.request;

import java.util.Comparator;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.PriorityBlockingQueue;
import org.eclipse.linuxtools.tmf.Tracer;
import org.eclipse.linuxtools.tmf.component.TmfThread;
import org.eclipse.linuxtools.tmf.request.ITmfDataRequest;

public class TmfRequestExecutor
implements Executor {
    private final ExecutorService fExecutor;
    private final String fExecutorName;
    private final PriorityBlockingQueue<TmfThread> fRequestQueue = new PriorityBlockingQueue<TmfThread>(100, new Comparator<TmfThread>(){

        @Override
        public int compare(TmfThread o1, TmfThread o2) {
            if (o1.getExecType() == o2.getExecType()) {
                return 0;
            }
            if (o1.getExecType() == ITmfDataRequest.ExecutionType.BACKGROUND) {
                return 1;
            }
            return -1;
        }
    });
    private Runnable fCurrentRequest;

    public TmfRequestExecutor() {
        this(Executors.newSingleThreadExecutor());
    }

    public TmfRequestExecutor(ExecutorService executor) {
        this.fExecutor = executor;
        String canonicalName = this.fExecutor.getClass().getCanonicalName();
        this.fExecutorName = canonicalName.substring(canonicalName.lastIndexOf(46) + 1);
        if (Tracer.isComponentTraced()) {
            Tracer.trace(this.fExecutor + " created");
        }
    }

    public int getNbPendingRequests() {
        return this.fRequestQueue.size();
    }

    public synchronized boolean isShutdown() {
        return this.fExecutor.isShutdown();
    }

    public boolean isTerminated() {
        return this.fExecutor.isTerminated();
    }

    public void stop() {
        this.fExecutor.shutdown();
        if (Tracer.isComponentTraced()) {
            Tracer.trace(this.fExecutor + " terminated");
        }
    }

    @Override
    public synchronized void execute(final Runnable requestThread) {
        this.fRequestQueue.offer(new TmfThread(((TmfThread)requestThread).getExecType()){

            @Override
            public void run() {
                try {
                    requestThread.run();
                }
                finally {
                    TmfRequestExecutor.this.scheduleNext();
                }
            }
        });
        if (this.fCurrentRequest == null) {
            this.scheduleNext();
        }
    }

    protected synchronized void scheduleNext() {
        this.fCurrentRequest = this.fRequestQueue.poll();
        if (this.fCurrentRequest != null && !this.isShutdown()) {
            this.fExecutor.execute(this.fCurrentRequest);
        }
    }

    public String toString() {
        return "[TmfRequestExecutor(" + this.fExecutorName + ")]";
    }
}

