/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.changelog.core.actions;

import java.util.ArrayList;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IStorage;
import org.eclipse.core.runtime.IPath;
import org.eclipse.linuxtools.changelog.core.actions.PatchRangeElement;

public class PatchFile {
    private IStorage storage;
    private ArrayList<PatchRangeElement> pranges = new ArrayList();
    private boolean newfile = false;
    private boolean removedfile = false;
    private IResource resource;

    public boolean isNewfile() {
        return this.newfile;
    }

    public void setNewfile(boolean newfile) {
        this.newfile = newfile;
    }

    public boolean isRemovedFile() {
        return this.removedfile;
    }

    public void setRemovedFile(boolean removedfile) {
        this.removedfile = removedfile;
    }

    public PatchFile(IResource resource) {
        this.resource = resource;
    }

    public void addLineRange(int from, int to, boolean localChange) {
        this.pranges.add(new PatchRangeElement(from, to, localChange));
    }

    public PatchRangeElement[] getRanges() {
        Object[] tmpEle = this.pranges.toArray();
        PatchRangeElement[] ret = new PatchRangeElement[tmpEle.length];
        int i = 0;
        while (i < tmpEle.length) {
            ret[i] = (PatchRangeElement)tmpEle[i];
            ++i;
        }
        return ret;
    }

    public IPath getPath() {
        return this.resource.getFullPath();
    }

    public IStorage getStorage() {
        return this.storage;
    }

    public void setStorage(IStorage storage) {
        this.storage = storage;
    }

    public IResource getResource() {
        return this.resource;
    }

    public int countRanges() {
        return this.pranges.size();
    }

    public boolean equals(Object o) {
        if (!(o instanceof PatchFile)) {
            return false;
        }
        PatchFile that = (PatchFile)o;
        if (!this.resource.equals((Object)that.resource) || this.countRanges() != that.countRanges()) {
            return false;
        }
        PatchRangeElement[] thatsrange = that.getRanges();
        int i = 0;
        while (i < this.countRanges()) {
            if (!thatsrange[i].equals(this.pranges.get(i))) {
                return false;
            }
            ++i;
        }
        return true;
    }
}

