/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.dataviewers.abstractviewers;

import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.linuxtools.dataviewers.STDataViewersActivator;
import org.eclipse.linuxtools.dataviewers.abstractviewers.AbstractSTTreeViewer;
import org.eclipse.linuxtools.dataviewers.abstractviewers.AbstractSTViewer;
import org.eclipse.linuxtools.dataviewers.abstractviewers.ISTDataViewersField;
import org.eclipse.linuxtools.dataviewers.abstractviewers.STDataViewersComparator;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Item;

public class STDataViewersCSVExporter {
    private final AbstractSTViewer stViewer;
    private PrintStream ps = null;
    private ISTDataViewersField[] fields = null;
    private List<Object> expandedElts = null;
    private Comparator<Object> comparator;
    private Object input = null;
    private IContentProvider contentProvider = null;
    private IDialogSettings state = null;
    private IProgressMonitor monitor;
    private String filePath = null;
    private String CSVSeparator = null;
    private String CSVChildMarker = null;
    private String CSVLastChildMarker = null;
    private String CSVChildLink = null;
    private String CSVNoChildLink = null;
    private String CSVLeafMarker = null;
    private String CSVNodeMarker = null;
    private boolean expandAll = false;
    private boolean showHiddenColumns = false;
    private boolean exportTreePrefix = false;

    public STDataViewersCSVExporter(AbstractSTViewer stViewer) {
        this.stViewer = stViewer;
        this.ps = System.out;
        this.state = stViewer.getViewerSettings().getSection("csv_exporter_section");
        this.restoreState();
    }

    public void restoreState() {
        if (this.state == null) {
            this.resetState();
            return;
        }
        try {
            this.filePath = this.state.get("csv_exporter_output_file_path");
            if (this.filePath == null) {
                this.resetState();
                return;
            }
            this.CSVSeparator = this.state.get("csv_exporter_separator");
            if (this.CSVSeparator == null) {
                this.resetState();
                return;
            }
            this.CSVChildMarker = this.state.get("csv_exporter_child_marker");
            if (this.CSVChildMarker == null) {
                this.resetState();
                return;
            }
            this.CSVLastChildMarker = this.state.get("csv_exporter_last_child_marker");
            if (this.CSVLastChildMarker == null) {
                this.resetState();
                return;
            }
            this.CSVChildLink = this.state.get("csv_exporter_child_link");
            if (this.CSVChildLink == null) {
                this.resetState();
                return;
            }
            this.CSVNoChildLink = this.state.get("csv_exporter_no_child_link");
            if (this.CSVNoChildLink == null) {
                this.resetState();
                return;
            }
            this.CSVLeafMarker = this.state.get("csv_exporter_leaf_marker");
            if (this.CSVLeafMarker == null) {
                this.resetState();
                return;
            }
            this.CSVNodeMarker = this.state.get("csv_exporter_node_marker");
            if (this.CSVNodeMarker == null) {
                this.resetState();
                return;
            }
            String temp = this.state.get("csv_exporter_expand_all");
            if (temp == null) {
                this.resetState();
                return;
            }
            this.expandAll = Boolean.parseBoolean(temp);
            temp = this.state.get("csv_exporter_show_hidden_columns");
            if (temp == null) {
                this.resetState();
                return;
            }
            this.showHiddenColumns = Boolean.parseBoolean(temp);
            if (this.isTreeViewerExporter()) {
                temp = this.state.get("csv_exporter_tree_prefix");
                if (temp == null) {
                    this.resetState();
                    return;
                }
                this.exportTreePrefix = Boolean.parseBoolean(temp);
            } else {
                this.exportTreePrefix = false;
            }
        }
        catch (NumberFormatException nfe) {
            Status s = new Status(2, "org.eclipse.linuxtools.dataviewers", "Invalid parameter, resetting configuration!\n" + nfe.getMessage(), (Throwable)nfe);
            this.logStatus((IStatus)s);
            this.resetState();
        }
    }

    public void saveState() {
        if (this.state == null) {
            this.state = this.stViewer.getViewerSettings().addNewSection("csv_exporter_section");
        }
        this.state.put("csv_exporter_output_file_path", this.filePath);
        this.state.put("csv_exporter_separator", this.CSVSeparator);
        this.state.put("csv_exporter_child_marker", this.CSVChildMarker);
        this.state.put("csv_exporter_last_child_marker", this.CSVLastChildMarker);
        this.state.put("csv_exporter_child_link", this.CSVChildLink);
        this.state.put("csv_exporter_no_child_link", this.CSVNoChildLink);
        this.state.put("csv_exporter_leaf_marker", this.CSVLeafMarker);
        this.state.put("csv_exporter_node_marker", this.CSVNodeMarker);
        this.state.put("csv_exporter_expand_all", this.expandAll);
        this.state.put("csv_exporter_show_hidden_columns", this.showHiddenColumns);
        if (this.isTreeViewerExporter()) {
            this.state.put("csv_exporter_tree_prefix", this.exportTreePrefix);
        } else {
            this.state.put("csv_exporter_tree_prefix", false);
        }
    }

    public void resetState() {
        this.filePath = "./export.csv";
        this.CSVSeparator = ";";
        this.CSVChildMarker = "+-";
        this.CSVLastChildMarker = "+-";
        this.CSVChildLink = "| ";
        this.CSVNoChildLink = "  ";
        this.CSVLeafMarker = "";
        this.CSVNodeMarker = "";
        this.expandAll = true;
        this.showHiddenColumns = true;
        this.exportTreePrefix = this.isTreeViewerExporter();
    }

    private void logStatus(IStatus s) {
        STDataViewersActivator.getDefault().getLog().log(s);
    }

    public void exportTo(String filePath) {
        this.setFilePath(filePath);
        this.export();
    }

    public void exportTo(String filePath, IProgressMonitor monitor) {
        this.setFilePath(filePath);
        this.export(monitor);
    }

    public void export() {
        this.export((IProgressMonitor)new NullProgressMonitor());
    }

    public void export(IProgressMonitor monitor) {
        this.monitor = monitor;
        monitor.beginTask("Exporting to CSV (file: " + this.getFilePath() + ")", -1);
        this.saveState();
        this.initPrintStream(this.filePath);
        if (monitor != null) {
            monitor.subTask("collecting viewer's parameters...");
        }
        this.collectViewerParameters();
        this.dumpColumnHeaders();
        if (this.input != null) {
            IStructuredContentProvider structContentProvider;
            Object[] topElements;
            if (this.contentProvider instanceof ITreeContentProvider) {
                ITreeContentProvider treeContentProvider = (ITreeContentProvider)this.contentProvider;
                topElements = treeContentProvider.getElements(this.input);
                if (topElements != null) {
                    int work = topElements.length;
                    Object[] objectArray = topElements;
                    int n = topElements.length;
                    int n2 = 0;
                    while (n2 < n) {
                        Object element = objectArray[n2];
                        if (treeContentProvider.hasChildren(element)) {
                            work += treeContentProvider.getChildren(element).length;
                        }
                        ++n2;
                    }
                    if (monitor != null) {
                        monitor.beginTask("Exporting to CSV (file: " + this.getFilePath() + ")", work);
                        monitor.subTask("exporting tree data...");
                    }
                    int tempWork = 0;
                    int workFloor = topElements.length / 100;
                    if (workFloor == 0) {
                        workFloor = 1;
                    }
                    Arrays.sort(topElements, this.comparator);
                    int i = 0;
                    while (i < topElements.length) {
                        this.dumpTreeData(treeContentProvider, topElements[i], "", i == topElements.length - 1, true);
                        if (monitor != null && ++tempWork >= workFloor) {
                            if (monitor.isCanceled()) {
                                this.ps.close();
                                return;
                            }
                            monitor.worked(tempWork);
                            tempWork = 0;
                        }
                        ++i;
                    }
                    if (monitor != null && tempWork > 0) {
                        monitor.worked(tempWork);
                    }
                }
            } else if (this.contentProvider instanceof IStructuredContentProvider && (topElements = (structContentProvider = (IStructuredContentProvider)this.contentProvider).getElements(this.input)) != null) {
                if (monitor != null) {
                    monitor.beginTask("Exporting to CSV (file: " + this.getFilePath() + ")", topElements.length);
                    monitor.subTask("exporting table data...");
                }
                int tempWork = 0;
                int workFloor = topElements.length / 100;
                if (workFloor == 0) {
                    workFloor = 1;
                }
                Arrays.sort(topElements, this.comparator);
                int n = 0;
                while (n < topElements.length) {
                    if (n < topElements.length - 1) {
                        this.dumpNodeData(topElements[n], this.CSVChildMarker);
                    } else {
                        this.dumpNodeData(topElements[n], this.CSVLastChildMarker);
                    }
                    if (monitor != null && ++tempWork >= workFloor) {
                        if (monitor.isCanceled()) {
                            this.ps.close();
                            return;
                        }
                        monitor.worked(tempWork);
                        tempWork = 0;
                    }
                    ++n;
                }
                if (monitor != null && tempWork > 0) {
                    monitor.worked(tempWork);
                }
            }
        }
        this.ps.close();
        monitor.done();
        IFile c = ResourcesPlugin.getWorkspace().getRoot().getFileForLocation((IPath)new Path(this.getFilePath()));
        if (c != null) {
            try {
                c.refreshLocal(1, (IProgressMonitor)new NullProgressMonitor());
            }
            catch (CoreException e) {
                e.printStackTrace();
            }
        }
    }

    private void initPrintStream(String filePath) {
        try {
            File outputFile = new File(filePath);
            if (outputFile.exists()) {
                outputFile.delete();
            }
            outputFile.createNewFile();
            this.ps = new PrintStream(outputFile);
        }
        catch (IOException e) {
            Status s = new Status(4, "org.eclipse.linuxtools.dataviewers", "Invalid file! Dumping to stdout...\n" + e.getMessage(), (Throwable)e);
            this.logStatus((IStatus)s);
            this.ps = System.out;
        }
        catch (NullPointerException e) {
            Status s = new Status(4, "org.eclipse.linuxtools.dataviewers", "File has not been set! Dumping to stdout...\n" + e.getMessage(), (Throwable)e);
            this.logStatus((IStatus)s);
            this.ps = System.out;
        }
    }

    private void collectViewerParameters() {
        Display.getDefault().syncExec(new Runnable(){

            @Override
            public void run() {
                Item[] unOrdColumns = STDataViewersCSVExporter.this.stViewer.getColumns();
                Item[] columns = new Item[unOrdColumns.length];
                int[] columnOrder = STDataViewersCSVExporter.this.stViewer.getColumnOrder();
                int i = 0;
                while (i < unOrdColumns.length) {
                    columns[i] = unOrdColumns[columnOrder[i]];
                    ++i;
                }
                HashMap<Item, ISTDataViewersField> fieldsMap = new HashMap<Item, ISTDataViewersField>();
                Item[] itemArray = columns;
                int n = columns.length;
                int n2 = 0;
                while (n2 < n) {
                    Item column = itemArray[n2];
                    fieldsMap.put(column, (ISTDataViewersField)column.getData());
                    ++n2;
                }
                STDataViewersCSVExporter.this.comparator = new CSVDataComparator(STDataViewersCSVExporter.this.stViewer.getTableSorter(), fieldsMap);
                if (!STDataViewersCSVExporter.this.showHiddenColumns) {
                    int[] columnsState = STDataViewersCSVExporter.this.stViewer.getHideShowManager().getColumnsState();
                    ArrayList<Item> enabledColumns = new ArrayList<Item>();
                    int i2 = 0;
                    while (i2 < columnsState.length) {
                        if (columnsState[columnOrder[i2]] == 1) {
                            enabledColumns.add(columns[i2]);
                        }
                        ++i2;
                    }
                    columns = enabledColumns.toArray(new Item[enabledColumns.size()]);
                }
                STDataViewersCSVExporter.this.fields = new ISTDataViewersField[columns.length];
                int i3 = 0;
                while (i3 < columns.length) {
                    ((STDataViewersCSVExporter)STDataViewersCSVExporter.this).fields[i3] = (ISTDataViewersField)columns[i3].getData();
                    ++i3;
                }
                STDataViewersCSVExporter.this.input = STDataViewersCSVExporter.this.stViewer.getViewer().getInput();
                STDataViewersCSVExporter.this.contentProvider = STDataViewersCSVExporter.this.stViewer.getViewer().getContentProvider();
                STDataViewersCSVExporter.this.expandedElts = new ArrayList();
                if (!STDataViewersCSVExporter.this.expandAll && STDataViewersCSVExporter.this.stViewer.getViewer() instanceof TreeViewer) {
                    TreeViewer tv = (TreeViewer)STDataViewersCSVExporter.this.stViewer.getViewer();
                    STDataViewersCSVExporter.this.expandedElts = Arrays.asList(tv.getExpandedElements());
                }
            }
        });
    }

    private void dumpColumnHeaders() {
        this.printPrefix("Hierarchy");
        int i = 0;
        while (i < this.fields.length) {
            this.ps.print(this.fields[i].getColumnHeaderText());
            this.printSeparator(i, this.fields.length);
            ++i;
        }
    }

    private void dumpTreeData(ITreeContentProvider tcp, Object element, String prefix, boolean isLastChild, boolean monitoring) {
        Object[] children;
        String childMarker = isLastChild ? this.CSVLastChildMarker : this.CSVChildMarker;
        boolean isLeaf = !tcp.hasChildren(element);
        String leafMarker = isLeaf ? this.CSVLeafMarker : this.CSVNodeMarker;
        this.dumpNodeData(element, String.valueOf(prefix) + childMarker + leafMarker);
        if ((this.expandAll || this.expandedElts.contains(element)) && !isLeaf && (children = tcp.getChildren(element)) != null) {
            int tempWork = 0;
            int workFloor = children.length / 100;
            if (workFloor == 0) {
                workFloor = 1;
            }
            Arrays.sort(children, this.comparator);
            int i = 0;
            while (i < children.length) {
                String prefixAdd = isLastChild ? this.CSVNoChildLink : this.CSVChildLink;
                this.dumpTreeData(tcp, children[i], String.valueOf(prefix) + prefixAdd, i == children.length - 1, false);
                if (this.monitor != null && monitoring && ++tempWork >= workFloor) {
                    this.monitor.worked(tempWork);
                    tempWork = 0;
                }
                ++i;
            }
            if (this.monitor != null && monitoring && tempWork > 0) {
                this.monitor.worked(tempWork);
            }
        }
    }

    private void dumpNodeData(Object element, String prefix) {
        int i = 0;
        while (i < this.fields.length) {
            this.printNode(i, prefix, this.getText(i, element));
            this.printSeparator(i, this.fields.length);
            ++i;
        }
    }

    private void printNode(int col, String prefix, String text) {
        if (col == 0) {
            this.printPrefix(prefix);
        }
        this.ps.print(text);
    }

    private void printPrefix(String prefix) {
        if (this.exportTreePrefix) {
            this.ps.print(prefix);
            this.ps.print(this.CSVSeparator);
        }
    }

    private void printSeparator(int i, int length) {
        if (i == length - 1) {
            this.ps.print("\n");
        } else {
            this.ps.print(this.CSVSeparator);
        }
    }

    private String getText(int i, Object obj) {
        return this.fields[i].getValue(obj);
    }

    public String getFilePath() {
        return this.filePath;
    }

    public String getCSVSeparator() {
        return this.CSVSeparator;
    }

    public String getCSVChildMarker() {
        return this.CSVChildMarker;
    }

    public String getCSVLastChildMarker() {
        return this.CSVLastChildMarker;
    }

    public String getCSVChildLink() {
        return this.CSVChildLink;
    }

    public String getCSVNoChildLink() {
        return this.CSVNoChildLink;
    }

    public String getCSVLeafMarker() {
        return this.CSVLeafMarker;
    }

    public String getCSVNodeMarker() {
        return this.CSVNodeMarker;
    }

    public boolean getExpandAll() {
        return this.expandAll;
    }

    public boolean getShowHiddenColumns() {
        return this.showHiddenColumns;
    }

    public boolean getExportTreePrefix() {
        return this.exportTreePrefix;
    }

    public void setFilePath(String filePath) {
        this.filePath = filePath;
    }

    public void setCSVSeparator(String separator) {
        this.CSVSeparator = separator;
    }

    public void setCSVChildMarker(String childMarker) {
        this.CSVChildMarker = childMarker;
    }

    public void setCSVLastChildMarker(String lastChildMarker) {
        this.CSVLastChildMarker = lastChildMarker;
    }

    public void setCSVChildLink(String childLink) {
        this.CSVChildLink = childLink;
    }

    public void setCSVNoChildLink(String noChildLink) {
        this.CSVNoChildLink = noChildLink;
    }

    public void setCSVLeafMarker(String leafMarker) {
        this.CSVLeafMarker = leafMarker;
    }

    public void setCSVNodeMarker(String nodeMarker) {
        this.CSVNodeMarker = nodeMarker;
    }

    public void setExpandAll(boolean expandAll) {
        this.expandAll = expandAll;
    }

    public void setShowHiddenColumns(boolean showHiddenColumns) {
        this.showHiddenColumns = showHiddenColumns;
    }

    public void setExportTreePrefix(boolean exportTreePrefix) {
        this.exportTreePrefix = this.isTreeViewerExporter() ? exportTreePrefix : false;
    }

    public boolean isTreeViewerExporter() {
        return this.stViewer instanceof AbstractSTTreeViewer;
    }

    private class CSVDataComparator
    extends STDataViewersComparator {
        private Map<Item, ISTDataViewersField> fieldsMap;

        public CSVDataComparator(STDataViewersComparator other, Map<Item, ISTDataViewersField> fieldsMap) {
            super(other);
            this.fieldsMap = fieldsMap;
        }

        @Override
        protected ISTDataViewersField getField(Item column) {
            return this.fieldsMap.get(column);
        }
    }
}

