/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.lttng.ui.views.project.handlers;

import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.IHandler;
import org.eclipse.core.commands.IHandlerListener;
import org.eclipse.core.resources.IFolder;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.linuxtools.lttng.ui.views.project.ProjectView;
import org.eclipse.linuxtools.lttng.ui.views.project.dialogs.NewExperimentDialog;
import org.eclipse.linuxtools.lttng.ui.views.project.model.ILTTngProjectTreeNode;
import org.eclipse.linuxtools.lttng.ui.views.project.model.LTTngExperimentFolderNode;
import org.eclipse.linuxtools.lttng.ui.views.project.model.LTTngProjectNode;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;

public class NewExperimentHandler
implements IHandler {
    private LTTngProjectNode fProject = null;

    public boolean isEnabled() {
        Object element;
        IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        if (window == null) {
            return false;
        }
        IWorkbenchPage page = window.getActivePage();
        if (!(page.getActivePart() instanceof ProjectView)) {
            return false;
        }
        ISelection selection = page.getSelection("org.eclipse.linuxtools.lttng.ui.views.project");
        if (selection instanceof StructuredSelection && (element = ((StructuredSelection)selection).getFirstElement()) instanceof ILTTngProjectTreeNode) {
            ILTTngProjectTreeNode node = (ILTTngProjectTreeNode)element;
            while (node != null && !(node instanceof LTTngProjectNode)) {
                node = node.getParent();
            }
            LTTngProjectNode lTTngProjectNode = this.fProject = node instanceof LTTngProjectNode ? (LTTngProjectNode)node : null;
        }
        return this.fProject != null && this.fProject.isOpen() && this.fProject.isLTTngProject();
    }

    public boolean isHandled() {
        return true;
    }

    public Object execute(ExecutionEvent event) throws ExecutionException {
        Object[] experiments;
        LTTngExperimentFolderNode experimentFolder = this.fProject.getExperimentsFolder();
        Shell shell = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell();
        NewExperimentDialog dialog = new NewExperimentDialog(shell, experimentFolder);
        dialog.open();
        if (dialog.getReturnCode() == 0 && (experiments = dialog.getResult())[0] instanceof IFolder) {
            experimentFolder.addExperiment((IFolder)experiments[0]);
        }
        return null;
    }

    public void dispose() {
    }

    public void addHandlerListener(IHandlerListener handlerListener) {
    }

    public void removeHandlerListener(IHandlerListener handlerListener) {
    }
}

