/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.tmf.trace;

import java.io.File;
import java.io.FileNotFoundException;
import java.util.Collections;
import java.util.Vector;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.linuxtools.tmf.component.TmfEventProvider;
import org.eclipse.linuxtools.tmf.event.TmfEvent;
import org.eclipse.linuxtools.tmf.event.TmfTimeRange;
import org.eclipse.linuxtools.tmf.event.TmfTimestamp;
import org.eclipse.linuxtools.tmf.request.ITmfDataRequest;
import org.eclipse.linuxtools.tmf.request.ITmfEventRequest;
import org.eclipse.linuxtools.tmf.request.TmfEventRequest;
import org.eclipse.linuxtools.tmf.signal.TmfTraceUpdatedSignal;
import org.eclipse.linuxtools.tmf.trace.ITmfContext;
import org.eclipse.linuxtools.tmf.trace.ITmfLocation;
import org.eclipse.linuxtools.tmf.trace.ITmfTrace;
import org.eclipse.linuxtools.tmf.trace.TmfCheckpoint;
import org.eclipse.linuxtools.tmf.trace.TmfContext;

public abstract class TmfTrace<T extends TmfEvent>
extends TmfEventProvider<T>
implements ITmfTrace<T>,
Cloneable {
    public static final int DEFAULT_INDEX_PAGE_SIZE = 50000;
    private String fPath;
    private String fTraceName;
    protected int fIndexPageSize = 50000;
    protected Vector<TmfCheckpoint> fCheckpoints = new Vector();
    protected long fNbEvents = 0L;
    private TmfTimestamp fStartTime = TmfTimestamp.BigCrunch;
    private TmfTimestamp fEndTime = TmfTimestamp.BigBang;

    public TmfTrace() {
    }

    @Override
    public void initTrace(String path, Class<T> eventType) throws FileNotFoundException {
        this.initTmfTrace(path, eventType, 50000, false);
    }

    @Override
    public void initTrace(String path, Class<T> eventType, int cacheSize) throws FileNotFoundException {
        this.initTmfTrace(path, eventType, cacheSize, false);
    }

    @Override
    public void initTrace(String path, Class<T> eventType, boolean indexTrace) throws FileNotFoundException {
        this.initTmfTrace(path, eventType, 50000, indexTrace);
    }

    @Override
    public void initTrace(String path, Class<T> eventType, int cacheSize, boolean indexTrace) throws FileNotFoundException {
        this.initTmfTrace(path, eventType, cacheSize, indexTrace);
    }

    private void initTmfTrace(String path, Class<T> eventType, int cacheSize, boolean indexTrace) throws FileNotFoundException {
        this.fPath = path;
        if (this.fTraceName == null) {
            this.fTraceName = "";
            if (path != null) {
                int sep = path.lastIndexOf(File.separator);
                this.fTraceName = sep >= 0 ? path.substring(sep + 1) : path;
            }
        }
        super.init(this.fTraceName, eventType);
        int n = this.fIndexPageSize = cacheSize > 0 ? cacheSize : 50000;
        if (indexTrace) {
            this.indexTrace(false);
        }
    }

    @Override
    public boolean validate(IProject project, String path) {
        File file = new File(path);
        return file.exists();
    }

    protected TmfTrace(String name, Class<T> type, String path) throws FileNotFoundException {
        this(name, type, path, 50000, true);
    }

    protected TmfTrace(String name, Class<T> type, String path, int cacheSize) throws FileNotFoundException {
        this(name, type, path, cacheSize, true);
    }

    protected TmfTrace(String name, Class<T> type, String path, boolean indexTrace) throws FileNotFoundException {
        this(name, type, path, 50000, indexTrace);
    }

    protected TmfTrace(String name, Class<T> type, String path, int cacheSize, boolean indexTrace) throws FileNotFoundException {
        this.fTraceName = name;
        this.initTrace(path, type, cacheSize, indexTrace);
    }

    public TmfTrace<T> clone() throws CloneNotSupportedException {
        TmfTrace clone = (TmfTrace)super.clone();
        clone.fCheckpoints = this.fCheckpoints;
        clone.fStartTime = new TmfTimestamp(this.fStartTime);
        clone.fEndTime = new TmfTimestamp(this.fEndTime);
        return clone;
    }

    @Override
    public String getPath() {
        return this.fPath;
    }

    @Override
    public long getNbEvents() {
        return this.fNbEvents;
    }

    @Override
    public int getCacheSize() {
        return this.fIndexPageSize;
    }

    @Override
    public TmfTimeRange getTimeRange() {
        return new TmfTimeRange(this.fStartTime, this.fEndTime);
    }

    @Override
    public TmfTimestamp getStartTime() {
        return this.fStartTime;
    }

    @Override
    public TmfTimestamp getEndTime() {
        return this.fEndTime;
    }

    public Vector<TmfCheckpoint> getCheckpoints() {
        return (Vector)this.fCheckpoints.clone();
    }

    @Override
    public long getRank(TmfTimestamp timestamp) {
        TmfContext context = this.seekEvent(timestamp);
        return context.getRank();
    }

    protected void setTimeRange(TmfTimeRange range) {
        this.fStartTime = range.getStartTime();
        this.fEndTime = range.getEndTime();
    }

    protected void setStartTime(TmfTimestamp startTime) {
        this.fStartTime = startTime;
    }

    protected void setEndTime(TmfTimestamp endTime) {
        this.fEndTime = endTime;
    }

    @Override
    public ITmfContext armRequest(ITmfDataRequest<T> request) {
        if (request instanceof ITmfEventRequest && !TmfTimestamp.BigBang.equals(((ITmfEventRequest)request).getRange().getStartTime()) && request.getIndex() == 0) {
            TmfContext context = this.seekEvent(((ITmfEventRequest)request).getRange().getStartTime());
            ((ITmfEventRequest)request).setStartIndex((int)context.getRank());
            return context;
        }
        return this.seekEvent(request.getIndex());
    }

    @Override
    public T getNext(ITmfContext context) {
        if (context instanceof TmfContext) {
            return (T)this.getNextEvent((TmfContext)context);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public TmfContext seekEvent(TmfTimestamp timestamp) {
        ITmfLocation<?> location;
        int index;
        if (timestamp == null) {
            timestamp = TmfTimestamp.BigBang;
        }
        if ((index = Collections.binarySearch(this.fCheckpoints, new TmfCheckpoint(timestamp, null))) < 0) {
            index = Math.max(0, -(index + 2));
        }
        Vector<TmfCheckpoint> vector = this.fCheckpoints;
        synchronized (vector) {
            if (this.fCheckpoints.size() > 0) {
                if (index >= this.fCheckpoints.size()) {
                    index = this.fCheckpoints.size() - 1;
                }
                location = this.fCheckpoints.elementAt(index).getLocation();
            } else {
                location = null;
            }
        }
        TmfContext context = this.seekLocation(location);
        context.setRank(index * this.fIndexPageSize);
        TmfContext nextEventContext = context.clone();
        TmfEvent event = this.getNextEvent(nextEventContext);
        while (event != null && event.getTimestamp().compareTo(timestamp, false) < 0) {
            context.setLocation(nextEventContext.getLocation().clone());
            context.updateRank(1);
            event = this.getNextEvent(nextEventContext);
        }
        return context;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public TmfContext seekEvent(long rank) {
        ITmfLocation<?> location;
        int index = (int)rank / this.fIndexPageSize;
        Vector<TmfCheckpoint> vector = this.fCheckpoints;
        synchronized (vector) {
            if (this.fCheckpoints.size() == 0) {
                location = null;
            } else {
                if (index >= this.fCheckpoints.size()) {
                    index = this.fCheckpoints.size() - 1;
                }
                location = this.fCheckpoints.elementAt(index).getLocation();
            }
        }
        TmfContext context = this.seekLocation(location);
        long pos = index * this.fIndexPageSize;
        context.setRank(pos);
        if (pos < rank) {
            TmfEvent event = this.getNextEvent(context);
            while (event != null && ++pos < rank) {
                event = this.getNextEvent(context);
            }
        }
        return context;
    }

    @Override
    public synchronized TmfEvent getNextEvent(TmfContext context) {
        TmfEvent event = this.parseEvent(context);
        if (event != null) {
            this.updateIndex(context, context.getRank(), event.getTimestamp());
            context.setLocation((ITmfLocation<? extends Comparable<?>>)this.getCurrentLocation());
            context.updateRank(1);
            this.processEvent(event);
        }
        return event;
    }

    protected synchronized void updateIndex(ITmfContext context, long rank, TmfTimestamp timestamp) {
        if (this.fStartTime.compareTo(timestamp, false) > 0) {
            this.fStartTime = timestamp;
        }
        if (this.fEndTime.compareTo(timestamp, false) < 0) {
            this.fEndTime = timestamp;
        }
        if (context.isValidRank()) {
            if (this.fNbEvents <= rank) {
                this.fNbEvents = rank + 1L;
            }
            if (rank % (long)this.fIndexPageSize == 0L) {
                long position = rank / (long)this.fIndexPageSize;
                if ((long)this.fCheckpoints.size() == position) {
                    ITmfLocation<? extends Comparable> location = context.getLocation().clone();
                    this.fCheckpoints.add(new TmfCheckpoint(timestamp.clone(), location));
                }
            }
        }
    }

    protected void processEvent(TmfEvent event) {
    }

    public String toString() {
        return "[TmfTrace (" + this.getName() + ")]";
    }

    protected void indexTrace(boolean waitForCompletion) {
        final Job job = new Job("Indexing " + this.getName() + "..."){

            protected IStatus run(IProgressMonitor monitor) {
                while (!monitor.isCanceled()) {
                    try {
                        Thread.sleep(100L);
                    }
                    catch (InterruptedException interruptedException) {
                        return Status.OK_STATUS;
                    }
                }
                monitor.done();
                return Status.OK_STATUS;
            }
        };
        job.schedule();
        this.fCheckpoints.clear();
        TmfEventRequest<TmfEvent> request = new TmfEventRequest<TmfEvent>(TmfEvent.class, TmfTimeRange.Eternity, Integer.MAX_VALUE, this.fIndexPageSize, ITmfDataRequest.ExecutionType.BACKGROUND){
            TmfTimestamp startTime;
            TmfTimestamp lastTime;
            {
                super($anonymous0, $anonymous1, $anonymous2, $anonymous3, $anonymous4);
                this.startTime = null;
                this.lastTime = null;
            }

            @Override
            public void handleData(TmfEvent event) {
                super.handleData(event);
                if (event != null) {
                    TmfTimestamp ts = event.getTimestamp();
                    if (this.startTime == null) {
                        this.startTime = new TmfTimestamp(ts);
                    }
                    this.lastTime = new TmfTimestamp(ts);
                    if (this.getNbRead() % TmfTrace.this.fIndexPageSize == 0) {
                        this.updateTrace();
                    }
                }
            }

            @Override
            public void handleSuccess() {
                this.updateTrace();
            }

            @Override
            public void handleCompleted() {
                job.cancel();
                super.handleCompleted();
            }

            private void updateTrace() {
                int nbRead = this.getNbRead();
                if (nbRead != 0) {
                    TmfTrace.this.fStartTime = this.startTime;
                    TmfTrace.this.fEndTime = this.lastTime;
                    TmfTrace.this.fNbEvents = nbRead;
                    TmfTrace.this.notifyListeners();
                }
            }
        };
        this.sendRequest(request);
        if (waitForCompletion) {
            try {
                request.waitForCompletion();
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
    }

    protected void notifyListeners() {
        this.broadcast(new TmfTraceUpdatedSignal(this, this, new TmfTimeRange(this.fStartTime, this.fEndTime)));
    }
}

