/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.valgrind.massif;

import org.eclipse.core.resources.IFile;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.model.ISourceLocator;
import org.eclipse.debug.core.sourcelookup.ISourceLookupDirector;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.linuxtools.internal.valgrind.massif.MassifHeapTreeNode;
import org.eclipse.linuxtools.profiling.ui.ProfileUIUtils;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.FontMetrics;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.osgi.framework.BundleContext;

public class MassifPlugin
extends AbstractUIPlugin {
    public static final String PLUGIN_ID = "org.eclipse.linuxtools.valgrind.massif";
    public static final String EDITOR_ID = "org.eclipse.linuxtools.valgrind.massif.chartEditor";
    private static MassifPlugin plugin;
    protected ILaunchConfiguration config;
    protected ISourceLocator locator;
    public static final String TOOL_ID = "org.eclipse.linuxtools.valgrind.launch.massif";

    public void start(BundleContext context) throws Exception {
        super.start(context);
        plugin = this;
    }

    public void stop(BundleContext context) throws Exception {
        plugin = null;
        super.stop(context);
    }

    public static FontMetrics getFontMetrics(Control control) {
        GC gc = new GC((Drawable)control);
        gc.setFont(control.getFont());
        FontMetrics fontMetrics = gc.getFontMetrics();
        gc.dispose();
        return fontMetrics;
    }

    public void openEditorForNode(MassifHeapTreeNode element) {
        Object obj;
        ISourceLocator sourceLocator = MassifPlugin.getDefault().getSourceLocator();
        if (sourceLocator instanceof ISourceLookupDirector && (obj = ((ISourceLookupDirector)sourceLocator).getSourceElement((Object)element.getFilename())) != null && obj instanceof IFile) {
            try {
                ProfileUIUtils.openEditorAndSelect((String)((IFile)obj).getLocation().toOSString(), (int)element.getLine());
            }
            catch (PartInitException e) {
                e.printStackTrace();
            }
            catch (BadLocationException e) {
                e.printStackTrace();
            }
        }
    }

    public ISourceLocator getSourceLocator() {
        return this.locator;
    }

    protected void setSourceLocator(ISourceLocator locator) {
        this.locator = locator;
    }

    public ILaunchConfiguration getConfig() {
        return this.config;
    }

    public void setConfig(ILaunchConfiguration config) {
        this.config = config;
    }

    public static MassifPlugin getDefault() {
        return plugin;
    }
}

