/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.valgrind.massif.birt;

import org.eclipse.birt.chart.computation.DataPointHints;
import org.eclipse.birt.chart.device.ICallBackNotifier;
import org.eclipse.birt.chart.device.IDeviceRenderer;
import org.eclipse.birt.chart.event.WrappedStructureSource;
import org.eclipse.birt.chart.exception.ChartException;
import org.eclipse.birt.chart.factory.GeneratedChartState;
import org.eclipse.birt.chart.factory.Generator;
import org.eclipse.birt.chart.factory.RunTimeContext;
import org.eclipse.birt.chart.model.Chart;
import org.eclipse.birt.chart.model.attribute.Bounds;
import org.eclipse.birt.chart.model.attribute.CallBackValue;
import org.eclipse.birt.chart.model.attribute.impl.BoundsImpl;
import org.eclipse.birt.chart.util.PluginSettings;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.linuxtools.internal.valgrind.massif.MassifSnapshot;
import org.eclipse.linuxtools.internal.valgrind.massif.MassifViewPart;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;

public class ChartSVG
implements ICallBackNotifier {
    protected Chart cm = null;
    protected GeneratedChartState state = null;
    protected IDeviceRenderer deviceRenderer = null;
    private MassifViewPart view;

    public ChartSVG(Chart chart, MassifViewPart view) {
        this.view = view;
        this.cm = chart;
    }

    public void renderSVG(IPath svgPath) {
        try {
            RunTimeContext rtc = new RunTimeContext();
            this.deviceRenderer = PluginSettings.instance().getDevice("dv.SVG");
            Generator gr = Generator.instance();
            Bounds bo = BoundsImpl.create((double)0.0, (double)0.0, (double)800.0, (double)600.0);
            this.state = gr.build(this.deviceRenderer.getDisplayServer(), this.cm, bo, null, rtc, null);
            this.deviceRenderer.setProperty("device.file.identifier", (Object)svgPath.toOSString());
            this.deviceRenderer.setProperty("device.component", (Object)this);
            gr.render(this.deviceRenderer, this.state);
        }
        catch (ChartException e) {
            e.printStackTrace();
        }
    }

    public void callback(Object event, Object source, CallBackValue value) {
        this.showView();
        MouseEvent mEvent = (MouseEvent)event;
        DataPointHints point = (DataPointHints)((WrappedStructureSource)source).getSource();
        TableViewer viewer = this.view.getTableViewer();
        this.view.setTopControl(viewer.getControl());
        MassifSnapshot snapshot = (MassifSnapshot)viewer.getElementAt(point.getIndex());
        switch (mEvent.count) {
            case 1: {
                viewer.setSelection((ISelection)new StructuredSelection((Object)snapshot));
            }
        }
    }

    public Chart getDesignTimeModel() {
        return this.cm;
    }

    public Chart getRunTimeModel() {
        return this.state.getChartModel();
    }

    public Object peerInstance() {
        return this;
    }

    public void regenerateChart() {
    }

    public void repaintChart() {
    }

    public void showView() {
        Display.getDefault().syncExec(new Runnable(){

            public void run() {
                try {
                    IWorkbenchPage activePage = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
                    activePage.showView("org.eclipse.linuxtools.valgrind.ui.valgrindview");
                }
                catch (PartInitException e) {
                    e.printStackTrace();
                }
            }
        });
    }
}

