/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.cdt.libhover.devhelp.preferences;

import java.io.File;
import java.io.FileOutputStream;
import java.io.ObjectOutputStream;
import java.util.Collection;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.preference.DirectoryFieldEditor;
import org.eclipse.jface.preference.FieldEditor;
import org.eclipse.jface.preference.FieldEditorPreferencePage;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.linuxtools.cdt.libhover.LibHoverInfo;
import org.eclipse.linuxtools.cdt.libhover.LibhoverPlugin;
import org.eclipse.linuxtools.cdt.libhover.devhelp.DevHelpPlugin;
import org.eclipse.linuxtools.internal.cdt.libhover.LibHover;
import org.eclipse.linuxtools.internal.cdt.libhover.LibHoverLibrary;
import org.eclipse.linuxtools.internal.cdt.libhover.devhelp.ParseDevHelp;
import org.eclipse.linuxtools.internal.cdt.libhover.devhelp.preferences.LabelFieldEditor;
import org.eclipse.linuxtools.internal.cdt.libhover.devhelp.preferences.LibHoverMessages;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;

public class LibHoverPreferencePage
extends FieldEditorPreferencePage
implements IWorkbenchPreferencePage {
    private static final String DEVHELP_DIR = "Libhover.Devhelp.Directory";
    private static final String GENERATE = "Libhover.Devhelp.Generate.lbl";
    private static final String REGENERATE_MSG = "Libhover.Devhelp.Regenerate.msg";
    private static final String TITLE = "Libhover.Devhelp.Preference.title";
    private Button generateButton;

    public LibHoverPreferencePage() {
        super(1);
        this.setPreferenceStore(DevHelpPlugin.getDefault().getPreferenceStore());
    }

    private synchronized void regenerate() {
        this.generateButton.setEnabled(false);
        Job k = new Job(LibHoverMessages.getString(REGENERATE_MSG)){

            protected IStatus run(IProgressMonitor monitor) {
                IPreferenceStore ps = DevHelpPlugin.getDefault().getPreferenceStore();
                ParseDevHelp.DevHelpParser p = new ParseDevHelp.DevHelpParser(ps.getString("org.eclipse.linuxtools.cdt.libhover.devhelp.directory"));
                LibHoverInfo hover = p.parse(monitor);
                Collection libs = LibHover.getLibraries();
                for (LibHoverLibrary l : libs) {
                    if (!l.getName().equals("devhelp")) continue;
                    l.setHoverinfo(hover);
                    break;
                }
                try {
                    IPath location = LibhoverPlugin.getDefault().getStateLocation().append("C");
                    File ldir = new File(location.toOSString());
                    ldir.mkdir();
                    location = location.append("devhelp.libhover");
                    FileOutputStream f = new FileOutputStream(location.toOSString());
                    ObjectOutputStream out = new ObjectOutputStream(f);
                    out.writeObject(hover);
                    out.close();
                    monitor.done();
                }
                catch (Exception e) {
                    monitor.done();
                    return new Status(4, "org.eclipse.linuxtools.cdt.libhover.devhelp", e.getLocalizedMessage(), (Throwable)e);
                }
                return Status.OK_STATUS;
            }
        };
        k.setUser(true);
        k.addJobChangeListener(new IJobChangeListener(){

            public void aboutToRun(IJobChangeEvent event) {
            }

            public void awake(IJobChangeEvent event) {
            }

            public void done(IJobChangeEvent event) {
                Display.getDefault().syncExec(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            LibHoverPreferencePage.this.generateButton.setEnabled(true);
                        }
                        catch (Exception exception) {}
                    }
                });
            }

            public void running(IJobChangeEvent event) {
            }

            public void scheduled(IJobChangeEvent event) {
            }

            public void sleeping(IJobChangeEvent event) {
            }
        });
        k.schedule();
    }

    protected void contributeButtons(Composite parent) {
        ++((GridLayout)parent.getLayout()).numColumns;
        this.generateButton = new Button(parent, 0);
        this.generateButton.setFont(parent.getFont());
        this.generateButton.setText(LibHoverMessages.getString(GENERATE));
        this.generateButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent evt) {
                LibHoverPreferencePage.this.regenerate();
            }
        });
        this.generateButton.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent event) {
                LibHoverPreferencePage.this.generateButton = null;
            }
        });
        GridData gd = new GridData();
        gd.horizontalAlignment = 4;
        int widthHint = this.convertHorizontalDLUsToPixels(61);
        gd.widthHint = Math.max(widthHint, this.generateButton.computeSize((int)-1, (int)-1, (boolean)true).x);
        this.generateButton.setLayoutData((Object)gd);
    }

    public void createFieldEditors() {
        this.addField(new LabelFieldEditor(this.getFieldEditorParent(), LibHoverMessages.getString(TITLE)));
        this.addField((FieldEditor)new DevhelpStringFieldEditor("org.eclipse.linuxtools.cdt.libhover.devhelp.directory", LibHoverMessages.getString(DEVHELP_DIR), this.getFieldEditorParent()));
    }

    public void init(IWorkbench workbench) {
    }

    private class DevhelpStringFieldEditor
    extends DirectoryFieldEditor {
        public DevhelpStringFieldEditor(String name, String labelText, Composite parent) {
            super(name, labelText, parent);
            this.setFilterPath(new File(DevHelpPlugin.getDefault().getPreferenceStore().getString(name)));
        }
    }
}

