/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.man.parser;

import org.eclipse.linuxtools.internal.man.parser.ManParser;

public class ManPage {
    private StringBuilder rawContent;

    public ManPage(String manPage) {
        this.parse(new ManParser().getRawManPage(manPage));
    }

    private void parse(StringBuilder rawManPage) {
        int index;
        StringBuilder sb = new StringBuilder();
        sb.append((CharSequence)rawManPage);
        while (sb.indexOf("_\b") != -1) {
            index = sb.indexOf("_\b");
            sb.replace(index, index + 3, "<u>" + sb.substring(index + 2, index + 3) + "</u>");
        }
        while (sb.indexOf("\b") != -1) {
            index = sb.indexOf("\b");
            sb.replace(index - 1, index + 2, "<b>" + sb.substring(index - 1, index) + "</b>");
        }
        this.rawContent = sb;
    }

    public StringBuilder getHtmlPage() {
        StringBuilder sb = new StringBuilder();
        sb.append("<pre>").append((CharSequence)this.rawContent).append("</pre>");
        return sb;
    }

    public StringBuilder getStrippedHtmlPage() {
        StringBuilder sb = new StringBuilder();
        sb.append((CharSequence)this.rawContent);
        if (sb.indexOf("<b>N</b>") != -1) {
            sb.delete(0, sb.indexOf("<b>N</b>"));
        }
        if (sb.indexOf("<b>A</b><b>U</b><b>T</b><b>H</b><b>O</b><b>R</b>") != -1) {
            sb.delete(sb.indexOf("<b>A</b><b>U</b><b>T</b><b>H</b><b>O</b><b>R</b>"), sb.length());
        }
        sb.insert(0, "<pre>");
        sb.append("</pre>");
        return sb;
    }
}

