/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.oprofile.ui.view;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.viewers.TreeSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.linuxtools.oprofile.core.OpcontrolException;
import org.eclipse.linuxtools.oprofile.core.OprofileCorePlugin;
import org.eclipse.linuxtools.oprofile.ui.OprofileUiPlugin;
import org.eclipse.linuxtools.oprofile.ui.model.UiModelSession;

public class OprofileViewDeleteSessionAction
extends Action {
    private TreeViewer treeViewer;

    public OprofileViewDeleteSessionAction(TreeViewer tree) {
        super("Delete Session");
        this.treeViewer = tree;
    }

    public void run() {
        TreeSelection tsl = (TreeSelection)this.treeViewer.getSelection();
        if (tsl.getFirstElement() instanceof UiModelSession) {
            UiModelSession sess = (UiModelSession)tsl.getFirstElement();
            this.deleteSession(sess);
        }
        OprofileUiPlugin.getDefault().getOprofileView().refreshView();
    }

    private void deleteSession(UiModelSession sess) {
        String sessionName = sess.getLabelText();
        String eventName = sess.getParent().getLabelText();
        try {
            OprofileCorePlugin.getDefault().getOpcontrolProvider().deleteSession(sessionName, eventName);
        }
        catch (OpcontrolException e) {
            OprofileCorePlugin.showErrorDialog((String)"opcontrolProvider", (CoreException)e);
        }
    }
}

