/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.perf.launch;

import java.io.File;
import java.text.MessageFormat;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.ui.AbstractLaunchConfigurationTab;
import org.eclipse.linuxtools.perf.PerfCore;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;

public class PerfOptionsTab
extends AbstractLaunchConfigurationTab {
    protected Text _txtKernel_Location;
    protected Button _chkRecord_Realtime;
    protected Button _chkRecord_Verbose;
    protected Button _chkSourceLineNumbers;
    protected Button _chkKernel_SourceLineNumbers;
    protected Button _chkMultiplexEvents;
    protected Button _chkModuleSymbols;
    protected Button _chkHideUnresolvedSymbols;
    protected Exception ex;

    public Image getImage() {
        return PlatformUI.getWorkbench().getSharedImages().getImage("IMG_OBJ_ELEMENTS");
    }

    public boolean isValid(ILaunchConfiguration config) {
        String filename;
        this.setErrorMessage(null);
        if (this.ex != null) {
            this.setErrorMessage(this.ex.getLocalizedMessage());
            return false;
        }
        if (this._txtKernel_Location != null && (filename = this._txtKernel_Location.getText()).length() > 0) {
            File file = new File(filename);
            return file.exists() && file.isFile();
        }
        return true;
    }

    public void createControl(Composite parent) {
        Composite top = new Composite(parent, 0);
        this.setControl((Control)top);
        top.setLayout((Layout)new GridLayout());
        this.createVerticalSpacer(top, 1);
        Composite p = new Composite(top, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        p.setLayout((Layout)layout);
        GridData data = new GridData(768);
        p.setLayoutData((Object)data);
        Label l = new Label(p, 0);
        l.setText("Location of kernel image file (optional): ");
        data = new GridData();
        data.horizontalSpan = 2;
        l.setLayoutData((Object)data);
        this._txtKernel_Location = new Text(p, 2052);
        data = new GridData(768);
        this._txtKernel_Location.setLayoutData((Object)data);
        this._txtKernel_Location.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent mev) {
                PerfOptionsTab.this._handleKernelImageFileTextModify(PerfOptionsTab.this._txtKernel_Location);
            }
        });
        Button button = this.createPushButton(p, "Browse", null);
        final Shell shell = top.getShell();
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent sev) {
                PerfOptionsTab.this._showFileDialog(shell);
            }
        });
        this.createVerticalSpacer(top, 1);
        p = new Composite(top, 0);
        layout = new GridLayout();
        layout.numColumns = 1;
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        p.setLayout((Layout)layout);
        data = new GridData(768);
        data.horizontalSpan = 2;
        p.setLayoutData((Object)data);
        this._chkRecord_Verbose = this._createCheckButton(p, "Record with verbose output");
        this._chkModuleSymbols = this._createCheckButton(p, "Load Module Symbols");
        this._chkHideUnresolvedSymbols = this._createCheckButton(p, "Hide Unresolved Symbols");
        this._chkSourceLineNumbers = this._createCheckButton(p, "Obtain source line numbers from profile data");
        this._chkSourceLineNumbers.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent se) {
                if (PerfOptionsTab.this._chkKernel_SourceLineNumbers != null && !PerfOptionsTab.this._chkSourceLineNumbers.getSelection()) {
                    PerfOptionsTab.this._chkKernel_SourceLineNumbers.setEnabled(false);
                } else {
                    PerfOptionsTab.this._chkKernel_SourceLineNumbers.setEnabled(true);
                }
            }
        });
        this._chkKernel_SourceLineNumbers = this._createCheckButton(p, "Obtain kernel source line numbers from profile data (Warning: May be very slow)");
        this._chkRecord_Realtime = this._createCheckButton(p, "Record with realtime priority (RT SCHED_FIFO)");
        this._chkMultiplexEvents = this._createCheckButton(p, "Multiplex counter output in a single channel");
    }

    private Button _createCheckButton(Composite parent, String label) {
        Button b = new Button(parent, 32);
        b.setText(label);
        b.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent se) {
                PerfOptionsTab.this.setDirty(true);
                PerfOptionsTab.this.updateLaunchConfigurationDialog();
            }
        });
        return b;
    }

    private void _handleKernelImageFileTextModify(Text text) {
        File file;
        String errorMessage = null;
        String filename = text.getText();
        if (!(filename.length() <= 0 || (file = new File(filename)).exists() && file.isFile())) {
            String msg = "The entered location does not exist";
            Object[] args = new Object[]{filename};
            errorMessage = MessageFormat.format(msg, args);
        }
        this.setErrorMessage(errorMessage);
        this.updateLaunchConfigurationDialog();
    }

    private void _showFileDialog(Shell shell) {
        FileDialog d = new FileDialog(shell, 4096);
        File kernel = new File(this._txtKernel_Location.getText());
        if (!kernel.exists() && !(kernel = new File("/boot")).exists()) {
            kernel = new File("/");
        }
        d.setFileName(kernel.toString());
        d.setText("Select location of kernel image file");
        String newKernel = d.open();
        if (newKernel != null) {
            kernel = new File(newKernel);
            if (!kernel.exists()) {
                MessageBox mb = new MessageBox(shell, 1281);
                mb.setMessage("File doesn't exist");
                switch (mb.open()) {
                    case 1024: {
                        this._showFileDialog(shell);
                        break;
                    }
                }
            } else {
                this._txtKernel_Location.setText(newKernel);
            }
        }
    }

    public String getName() {
        return "Perf Options";
    }

    public void initializeFrom(ILaunchConfiguration config) {
        try {
            if (!PerfCore.checkPerfInPath()) {
                Status status = new Status(4, "org.eclipse.linuxtools.perf", "Error: Perf was not found on PATH");
                this.ex = new CoreException((IStatus)status);
            }
            this._txtKernel_Location.setText(config.getAttribute("org.eclipse.linuxtools.perf.attr.Kernel.Location", ""));
            this._chkRecord_Realtime.setSelection(config.getAttribute("org.eclipse.linuxtools.perf.attr.Record.Realtime", false));
            this._chkRecord_Verbose.setSelection(config.getAttribute("org.eclipse.linuxtools.perf.attr.Record.Verbose", false));
            this._chkSourceLineNumbers.setSelection(config.getAttribute("org.eclipse.linuxtools.perf.attr.SourceLineNumbers", true));
            this._chkKernel_SourceLineNumbers.setSelection(config.getAttribute("org.eclipse.linuxtools.perf.attr.Kernel.SourceLineNumbers", false));
            this._chkMultiplexEvents.setSelection(config.getAttribute("org.eclipse.linuxtools.perf.attr.Multiplex", false));
            this._chkModuleSymbols.setSelection(config.getAttribute("org.eclipse.linuxtools.perf.attr.ModuleSymbols", false));
            this._chkHideUnresolvedSymbols.setSelection(config.getAttribute("org.eclipse.linuxtools.perf.attr.HideUnresolvedSymbols", true));
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
    }

    public void performApply(ILaunchConfigurationWorkingCopy wconfig) {
        wconfig.setAttribute("org.eclipse.linuxtools.perf.attr.Kernel.Location", this._txtKernel_Location.getText());
        wconfig.setAttribute("org.eclipse.linuxtools.perf.attr.Record.Realtime", this._chkRecord_Realtime.getSelection());
        wconfig.setAttribute("org.eclipse.linuxtools.perf.attr.Record.Verbose", this._chkRecord_Verbose.getSelection());
        wconfig.setAttribute("org.eclipse.linuxtools.perf.attr.SourceLineNumbers", this._chkSourceLineNumbers.getSelection());
        wconfig.setAttribute("org.eclipse.linuxtools.perf.attr.Kernel.SourceLineNumbers", this._chkKernel_SourceLineNumbers.getSelection());
        wconfig.setAttribute("org.eclipse.linuxtools.perf.attr.Multiplex", this._chkMultiplexEvents.getSelection());
        wconfig.setAttribute("org.eclipse.linuxtools.perf.attr.ModuleSymbols", this._chkModuleSymbols.getSelection());
        wconfig.setAttribute("org.eclipse.linuxtools.perf.attr.HideUnresolvedSymbols", this._chkHideUnresolvedSymbols.getSelection());
        try {
            wconfig.doSave();
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
    }

    public void setDefaults(ILaunchConfigurationWorkingCopy wconfig) {
        wconfig.setAttribute("org.eclipse.linuxtools.perf.attr.Kernel.Location", "");
        wconfig.setAttribute("org.eclipse.linuxtools.perf.attr.Record.Realtime", false);
        wconfig.setAttribute("org.eclipse.linuxtools.perf.attr.Record.Verbose", false);
        wconfig.setAttribute("org.eclipse.linuxtools.perf.attr.SourceLineNumbers", true);
        wconfig.setAttribute("org.eclipse.linuxtools.perf.attr.Kernel.SourceLineNumbers", false);
        wconfig.setAttribute("org.eclipse.linuxtools.perf.attr.Multiplex", false);
        wconfig.setAttribute("org.eclipse.linuxtools.perf.attr.ModuleSymbols", false);
        wconfig.setAttribute("org.eclipse.linuxtools.perf.attr.HideUnresolvedSymbols", true);
        try {
            wconfig.doSave();
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
    }
}

