/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.perf.model;

import org.eclipse.linuxtools.perf.model.PMCommand;
import org.eclipse.linuxtools.perf.model.PMFile;
import org.eclipse.linuxtools.perf.model.TreePercentable;

public class PMDso
extends TreePercentable {
    private String path = null;
    private boolean kernel = false;

    public boolean isKernelDso() {
        return this.kernel;
    }

    public PMDso(String dsoName, boolean kernel) {
        super(dsoName);
        this.kernel = kernel;
    }

    public PMFile getFile(String fileName) {
        PMFile tmp = (PMFile)this.getChild(fileName);
        if (tmp != null) {
            return tmp;
        }
        tmp = new PMFile(fileName);
        this.addChild(tmp);
        return tmp;
    }

    public void setPath(String filePath) {
        this.path = filePath;
    }

    @Override
    public String toString() {
        String prefix = "";
        if (this.percent != -1.0f) {
            prefix = String.valueOf(prefix) + this.percent + "% in ";
        }
        if (this.kernel) {
            prefix = String.valueOf(prefix) + "[k] ";
        }
        if (this.path != null) {
            return String.valueOf(prefix) + this.name + " (at " + this.path + ")";
        }
        return String.valueOf(prefix) + this.name;
    }

    public String getPath() {
        return this.path;
    }

    public PMCommand getCommand() {
        if (!(super.getParent() instanceof PMCommand)) {
            return null;
        }
        return (PMCommand)super.getParent();
    }
}

