/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.perf.ui;

import java.util.HashMap;
import org.eclipse.cdt.core.model.ICProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.linuxtools.perf.model.PMCommand;
import org.eclipse.linuxtools.perf.model.PMDso;
import org.eclipse.linuxtools.perf.model.PMEvent;
import org.eclipse.linuxtools.perf.model.PMFile;
import org.eclipse.linuxtools.perf.model.PMLineRef;
import org.eclipse.linuxtools.perf.model.PMSymbol;
import org.eclipse.linuxtools.profiling.ui.ProfileUIUtils;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PartInitException;

public class PerfDoubleClickAction
extends Action {
    private TreeViewer viewer;

    public PerfDoubleClickAction(TreeViewer v) {
        this.viewer = v;
    }

    public void run() {
        ISelection selection = this.viewer.getSelection();
        Object obj = ((IStructuredSelection)selection).getFirstElement();
        if (obj instanceof PMLineRef) {
            PMLineRef tmp = (PMLineRef)obj;
            try {
                ProfileUIUtils.openEditorAndSelect((String)tmp.getSymbol().getFile().getPath(), (int)Integer.parseInt(tmp.getName()));
            }
            catch (PartInitException e) {
                e.printStackTrace();
            }
            catch (BadLocationException e) {
                e.printStackTrace();
            }
        } else if (obj instanceof PMFile) {
            PMFile tmp = (PMFile)obj;
            try {
                ProfileUIUtils.openEditorAndSelect((String)tmp.getName(), (int)1);
            }
            catch (PartInitException e) {
                e.printStackTrace();
            }
            catch (BadLocationException e) {
                e.printStackTrace();
            }
        } else if (obj instanceof PMSymbol) {
            PMSymbol tmpsym = (PMSymbol)obj;
            if (tmpsym.getFile().getName().equals("Unfiled Symbols")) {
                return;
            }
            String binaryPath = tmpsym.getFile().getDso().getPath();
            try {
                ICProject project = ProfileUIUtils.findCProjectWithAbsolutePath((String)binaryPath);
                HashMap map = ProfileUIUtils.findFunctionsInProject((ICProject)project, (String)tmpsym.getFunctionName(), (int)-1, (String)tmpsym.getFile().getPath(), (boolean)true);
                boolean bFound = false;
                for (String loc : map.keySet()) {
                    ProfileUIUtils.openEditorAndSelect((String)loc, (int)((int[])map.get(loc))[0], (int)((int[])map.get(loc))[1]);
                    bFound = true;
                }
                if (!bFound) {
                    ProfileUIUtils.openEditorAndSelect((String)tmpsym.getFile().getPath(), (int)1);
                }
            }
            catch (CoreException e) {
                e.printStackTrace();
            }
            catch (BadLocationException e) {
                e.printStackTrace();
            }
        } else if (!(obj instanceof PMDso || obj instanceof PMCommand || obj instanceof PMEvent)) {
            this.showMessage("Double-click detected on " + obj.toString() + " " + obj.getClass().toString());
        }
    }

    private void showMessage(String message) {
        MessageDialog.openInformation((Shell)this.viewer.getControl().getShell(), (String)"Perf Profile View", (String)message);
    }
}

