/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.tmf.ui.views.uml2sd.core;

import java.util.Comparator;
import org.eclipse.linuxtools.tmf.core.event.ITmfTimestamp;
import org.eclipse.linuxtools.tmf.core.event.TmfTimestamp;
import org.eclipse.linuxtools.tmf.ui.views.uml2sd.core.BaseMessage;
import org.eclipse.linuxtools.tmf.ui.views.uml2sd.core.Frame;
import org.eclipse.linuxtools.tmf.ui.views.uml2sd.core.GraphNode;
import org.eclipse.linuxtools.tmf.ui.views.uml2sd.core.ITimeRange;
import org.eclipse.linuxtools.tmf.ui.views.uml2sd.core.Lifeline;
import org.eclipse.linuxtools.tmf.ui.views.uml2sd.core.Metrics;
import org.eclipse.linuxtools.tmf.ui.views.uml2sd.core.SyncMessageReturn;
import org.eclipse.linuxtools.tmf.ui.views.uml2sd.drawings.IGC;
import org.eclipse.linuxtools.tmf.ui.views.uml2sd.util.SortSyncMessageComparator;

public class SyncMessage
extends BaseMessage
implements ITimeRange {
    protected SyncMessageReturn messageReturn;
    protected ITmfTimestamp eventTime = new TmfTimestamp();
    public static final String SYNC_MESS_TAG = "SyncMessage";
    protected boolean hasTime = false;

    public SyncMessage() {
        this.prefId = "PREF_SYNC_MESS";
    }

    protected void syncLifelinesEventOccurrence() {
        if (this.getStartLifeline() != null && this.getEndLifeline() != null) {
            int newIndex = 0;
            newIndex = this.getStartLifeline().getEventOccurrence() > this.getEndLifeline().getEventOccurrence() ? this.getStartLifeline().getEventOccurrence() : this.getEndLifeline().getEventOccurrence();
            this.getStartLifeline().setCurrentEventOccurrence(newIndex);
            this.getEndLifeline().setCurrentEventOccurrence(newIndex);
            this.setEventOccurrence(this.getStartLifeline().getEventOccurrence());
        }
    }

    public void autoSetStartLifeline(Lifeline lifeline) {
        lifeline.getNewEventOccurrence();
        this.setStartLifeline(lifeline);
    }

    public void autoSetEndLifeline(Lifeline lifeline) {
        lifeline.getNewEventOccurrence();
        this.setEndLifeline(lifeline);
    }

    @Override
    public void setStartLifeline(Lifeline lifeline) {
        super.setStartLifeline(lifeline);
        if (this.getEndLifeline() == null) {
            this.setEventOccurrence(this.getStartLifeline().getEventOccurrence());
        } else {
            this.syncLifelinesEventOccurrence();
        }
    }

    @Override
    public void setEndLifeline(Lifeline lifeline) {
        super.setEndLifeline(lifeline);
        if (this.getStartLifeline() == null) {
            this.setEventOccurrence(this.getEndLifeline().getEventOccurrence());
        } else {
            this.syncLifelinesEventOccurrence();
        }
    }

    @Override
    protected void setEventOccurrence(int occurrence) {
        this.startEventOccurrence = occurrence;
        this.endEventOccurrence = occurrence;
    }

    protected void setMessageReturn(SyncMessageReturn message) {
        this.messageReturn = message;
    }

    public SyncMessageReturn getMessageReturn() {
        return this.messageReturn;
    }

    public void setTime(ITmfTimestamp time) {
        this.eventTime = time.clone();
        this.hasTime = true;
        if (this.getStartLifeline() != null && this.getStartLifeline().getFrame() != null) {
            this.getStartLifeline().getFrame().setHasTimeInfo(true);
        } else if (this.getEndLifeline() != null && this.getEndLifeline().getFrame() != null) {
            this.getEndLifeline().getFrame().setHasTimeInfo(true);
        }
    }

    @Override
    public ITmfTimestamp getEndTime() {
        return this.eventTime;
    }

    @Override
    public ITmfTimestamp getStartTime() {
        return this.eventTime;
    }

    @Override
    public boolean hasTimeInfo() {
        return this.hasTime;
    }

    @Override
    public void draw(IGC context) {
        if (!this.isVisible()) {
            return;
        }
        if (!this.isSelected()) {
            context.setBackground(Frame.getUserPref().getBackGroundColor(this.prefId));
            context.setForeground(Frame.getUserPref().getForeGroundColor(this.prefId));
        }
        super.draw(context);
    }

    @Override
    public boolean isVisible(int x, int y, int width, int height) {
        if (this.getY() > y + height + 10 + Metrics.getMessageFontHeigth()) {
            return false;
        }
        if ((this.endLifeline == null && this.startLifeline != null || this.endLifeline != null && this.startLifeline == null) && x + width > this.getX() + this.getWidth() && x < this.getX() + this.getWidth()) {
            return true;
        }
        return super.isVisible(x, y, width, height);
    }

    @Override
    public Comparator<GraphNode> getComparator() {
        return new SortSyncMessageComparator();
    }

    @Override
    public String getArrayId() {
        return SYNC_MESS_TAG;
    }

    @Override
    public boolean positiveDistanceToPoint(int x, int y) {
        return this.getY() > y;
    }
}

