/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.tools.launch.core.properties;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ProjectScope;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.preferences.IScopeContext;
import org.eclipse.ui.preferences.ScopedPreferenceStore;

public class LinuxtoolsPathProperty {
    public static final String LINUXTOOLS_PATH_NAME = "org.eclipse.linuxtools.tools.launch.core.LinuxtoolsPath";
    public static final String LINUXTOOLS_PATH_SYSTEM_NAME = "org.eclipse.linuxtools.tools.launch.core.LinuxtoolsSystemEnvPath";
    private static final String LINUXTOOLS_PATH_EXT_POINT = "LinuxtoolsPathOptions";
    private static final String LINUXTOOLS_PATH_OPTION = "option";
    private static final String LINUXTOOLS_PATH_OPTION_PATH = "path";
    private static final String LINUXTOOLS_PATH_OPTION_DEFAULT = "default";
    private String linuxtoolsPathDefault = "";
    private boolean linuxtoolsPathSystemDefault = true;
    private static LinuxtoolsPathProperty instance = null;

    private void fillLinuxtoolsPath(String path) {
        if (path == null) {
            return;
        }
        if (!path.equals("")) {
            this.linuxtoolsPathSystemDefault = false;
            this.linuxtoolsPathDefault = path;
        }
    }

    private LinuxtoolsPathProperty() {
        IExtensionPoint extPoint = Platform.getExtensionRegistry().getExtensionPoint("org.eclipse.linuxtools.tools.launch.ui", LINUXTOOLS_PATH_EXT_POINT);
        if (extPoint != null) {
            IConfigurationElement[] configs;
            IConfigurationElement[] iConfigurationElementArray = configs = extPoint.getConfigurationElements();
            int n = configs.length;
            int n2 = 0;
            while (n2 < n) {
                String sdefault;
                IConfigurationElement config = iConfigurationElementArray[n2];
                if (config.getName().equals(LINUXTOOLS_PATH_OPTION) && (sdefault = config.getAttribute(LINUXTOOLS_PATH_OPTION_DEFAULT)) != null && sdefault.equals(Boolean.toString(true))) {
                    this.fillLinuxtoolsPath(config.getAttribute(LINUXTOOLS_PATH_OPTION_PATH));
                    break;
                }
                ++n2;
            }
        }
    }

    public static LinuxtoolsPathProperty getInstance() {
        if (instance == null) {
            instance = new LinuxtoolsPathProperty();
        }
        return instance;
    }

    public String getLinuxtoolsPath(IProject project) {
        if (project == null) {
            return null;
        }
        ScopedPreferenceStore store = new ScopedPreferenceStore((IScopeContext)new ProjectScope(project), "org.eclipse.linuxtools.tools.launch.core");
        boolean systemPathSelected = store.contains(LINUXTOOLS_PATH_SYSTEM_NAME) ? store.getBoolean(LINUXTOOLS_PATH_SYSTEM_NAME) : this.getLinuxtoolsPathSystemDefault();
        if (systemPathSelected) {
            return this.getLinuxtoolsPathDefault();
        }
        String path = store.getString(LINUXTOOLS_PATH_NAME);
        if (path == null || path.equals("")) {
            return this.getLinuxtoolsPathDefault();
        }
        return path;
    }

    public String getLinuxtoolsPathDefault() {
        return this.linuxtoolsPathDefault;
    }

    public boolean getLinuxtoolsPathSystemDefault() {
        return this.linuxtoolsPathSystemDefault;
    }
}

