/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.callgraph.launch;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.cdt.core.model.CModelException;
import org.eclipse.cdt.core.model.ICContainer;
import org.eclipse.cdt.core.model.ICElement;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.linuxtools.internal.callgraph.launch.SystemTapLaunchShortcut;

public class ListTreeContentProvider
implements ITreeContentProvider {
    public Object[] getChildren(Object parentElement) {
        ArrayList<ICElement> output = new ArrayList<ICElement>();
        if (parentElement instanceof ICContainer) {
            try {
                ICElement[] list;
                ICElement[] iCElementArray = list = ((ICContainer)parentElement).getChildren();
                int n = list.length;
                int n2 = 0;
                while (n2 < n) {
                    ICElement el;
                    ICElement item = iCElementArray[n2];
                    if (item instanceof ICContainer) {
                        if (this.checkForValidChildren((ICContainer)item)) {
                            output.add(item);
                        }
                    } else if (item instanceof ICElement && SystemTapLaunchShortcut.validElement(el = item)) {
                        output.add(el);
                    }
                    ++n2;
                }
                return output.toArray();
            }
            catch (CModelException e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean checkForValidChildren(ICContainer cont) {
        try {
            ICElement[] iCElementArray = cont.getChildren();
            int n = iCElementArray.length;
            int n2 = 0;
            while (true) {
                if (n2 >= n) {
                    return false;
                }
                ICElement child = iCElementArray[n2];
                if (child instanceof ICElement && SystemTapLaunchShortcut.validElement(child)) {
                    return true;
                }
                if (child instanceof ICContainer && this.checkForValidChildren((ICContainer)child)) {
                    return true;
                }
                ++n2;
            }
        }
        catch (CModelException e) {
            e.printStackTrace();
        }
        return false;
    }

    public Object getParent(Object element) {
        if (element instanceof ICElement) {
            return ((ICElement)element).getAncestor(12);
        }
        return null;
    }

    public boolean hasChildren(Object element) {
        if (element instanceof ICContainer) {
            try {
                if (((ICContainer)element).getChildren().length > 0) {
                    return true;
                }
            }
            catch (CModelException e) {
                e.printStackTrace();
            }
        }
        return false;
    }

    public Object[] getElements(Object inputElement) {
        if (inputElement instanceof List) {
            for (Object element : (List)inputElement) {
                if (!(element instanceof ICContainer)) continue;
                try {
                    ICElement[] array = ((ICContainer)element).getChildren();
                    ArrayList<ICElement> output = new ArrayList<ICElement>();
                    ICElement[] iCElementArray = array;
                    int n = array.length;
                    int n2 = 0;
                    while (n2 < n) {
                        ICElement item = iCElementArray[n2];
                        if (item instanceof ICContainer && this.checkForValidChildren((ICContainer)item)) {
                            output.add(item);
                        }
                        if (SystemTapLaunchShortcut.validElement(item)) {
                            output.add(item);
                        }
                        ++n2;
                    }
                    return output.toArray();
                }
                catch (CModelException e) {
                    e.printStackTrace();
                }
            }
        }
        return null;
    }

    public void dispose() {
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
    }

    public Object[] findElements(Object inputElement) {
        ArrayList<Object> output = new ArrayList<Object>();
        if (inputElement instanceof List) {
            for (Object element : (List)inputElement) {
                Object[] list;
                Object[] objectArray = list = this.getChildren(element);
                int n = list.length;
                int n2 = 0;
                while (n2 < n) {
                    Object o = objectArray[n2];
                    output.add(o);
                    ++n2;
                }
            }
        }
        return output.toArray();
    }
}

